/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.config.apidoc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;

@WebEndpoint(id="luixopenapigroups")
public class OpenApiEndpoint {
    private final SpringDocConfigProperties springDocConfigProperties;
    private final String appName;

    public OpenApiEndpoint(SpringDocConfigProperties springDocConfigProperties, String appName) {
        this.springDocConfigProperties = springDocConfigProperties;
        this.appName = appName;
    }

    @ReadOperation
    public List<Map<String, String>> allOpenApi() {
        return this.springDocConfigProperties.getGroupConfigs().stream().map(this::createGroupMap).collect(Collectors.toList());
    }

    private Map<String, String> createGroupMap(SpringDocConfigProperties.GroupConfig group) {
        HashMap<String, String> map = new HashMap<String, String>();
        String groupName = group.getGroup();
        map.put("group", groupName);
        String description = this.appName + " (" + ("springdocDefault".equals(groupName) ? "default" : groupName) + ")";
        map.put("description", description);
        return map;
    }
}

