/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.config.apidoc;

import com.luixtech.springbootframework.config.apidoc.OpenApiEndpoint;
import com.luixtech.springbootframework.config.apidoc.SpringDocAutoConfiguration;
import java.util.Optional;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SpringDocConfigProperties.class})
@AutoConfigureAfter(value={SpringDocAutoConfiguration.class})
public class OpenApiEndpointConfiguration {
    @Bean
    @ConditionalOnBean(value={SpringDocConfigProperties.class})
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public OpenApiEndpoint openApiEndpoint(Optional<SpringDocConfigProperties> springDocConfigProperties, @Value(value="${spring.application.name:application}") String appName) {
        return springDocConfigProperties.map(docConfigProperties -> new OpenApiEndpoint((SpringDocConfigProperties)docConfigProperties, appName)).orElse(null);
    }
}

