/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.config.apidoc;

import com.luixtech.springbootframework.config.LuixProperties;
import com.luixtech.springbootframework.config.apidoc.NamedApiCustomizer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.ActuatorOperationCustomizer;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringDocGroupsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SpringDocGroupsConfiguration.class);
    public static final String API_GROUP_NAME = "api";
    public static final String OPEN_API_GROUP_NAME = "open-api";
    public static final String MANAGEMENT_GROUP_NAME = "management";
    private final LuixProperties.ApiDocs apiDocsProperties;
    private final Optional<BuildProperties> buildProperties;

    public SpringDocGroupsConfiguration(LuixProperties luixProperties, Optional<BuildProperties> buildProperties) {
        this.apiDocsProperties = luixProperties.getApiDocs();
        this.buildProperties = buildProperties;
    }

    @Bean
    public NamedApiCustomizer apiCustomizer() {
        NamedApiCustomizer customizer = new NamedApiCustomizer(this.apiDocsProperties, "api-customizer", this.apiDocsProperties.getApiTitle(), this.apiDocsProperties.getApiDescription(), this.getVersion(), 0);
        log.debug("Initialized Api customizer");
        return customizer;
    }

    @Bean
    public NamedApiCustomizer openApiCustomizer() {
        NamedApiCustomizer customizer = new NamedApiCustomizer(this.apiDocsProperties, "open-api-customizer", this.apiDocsProperties.getOpenApiTitle(), this.apiDocsProperties.getOpenApiDescription(), this.getVersion(), 1);
        return customizer;
    }

    @Bean
    public NamedApiCustomizer managementCustomizer() {
        NamedApiCustomizer customizer = new NamedApiCustomizer(this.apiDocsProperties, "management-customizer", this.apiDocsProperties.getManagementTitle(), this.apiDocsProperties.getManagementDescription(), this.getVersion(), 2);
        return customizer;
    }

    @Bean
    public GroupedOpenApi apiGroup(List<OpenApiCustomizer> openApiCustomizers, List<OperationCustomizer> operationCustomizers) {
        GroupedOpenApi.Builder builder = GroupedOpenApi.builder().group(API_GROUP_NAME).pathsToMatch(new String[]{this.apiDocsProperties.getApiIncludePattern()});
        openApiCustomizers.stream().filter(customizer -> customizer instanceof NamedApiCustomizer && ((NamedApiCustomizer)customizer).getName().equals("api-customizer")).forEach(arg_0 -> ((GroupedOpenApi.Builder)builder).addOpenApiCustomizer(arg_0));
        operationCustomizers.stream().filter(customizer -> !(customizer instanceof ActuatorOperationCustomizer)).forEach(arg_0 -> ((GroupedOpenApi.Builder)builder).addOperationCustomizer(arg_0));
        log.debug("Initialized api group");
        return builder.build();
    }

    @Bean
    public GroupedOpenApi openApiGroup(List<OpenApiCustomizer> openApiCustomizers, List<OperationCustomizer> operationCustomizers) {
        GroupedOpenApi.Builder builder = GroupedOpenApi.builder().group(OPEN_API_GROUP_NAME).pathsToMatch(new String[]{this.apiDocsProperties.getOpenApiIncludePattern()});
        openApiCustomizers.stream().filter(customizer -> customizer instanceof NamedApiCustomizer && ((NamedApiCustomizer)customizer).getName().equals("open-api-customizer")).forEach(arg_0 -> ((GroupedOpenApi.Builder)builder).addOpenApiCustomizer(arg_0));
        operationCustomizers.stream().filter(customizer -> !(customizer instanceof ActuatorOperationCustomizer)).forEach(arg_0 -> ((GroupedOpenApi.Builder)builder).addOperationCustomizer(arg_0));
        log.debug("Initialized open-api group");
        return builder.build();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties"})
    @ConditionalOnProperty(value={"springdoc.show-actuator"})
    public GroupedOpenApi managementGroupedOpenApi(List<OpenApiCustomizer> openApiCustomizers, List<OperationCustomizer> operationCustomizers) {
        GroupedOpenApi.Builder builder = GroupedOpenApi.builder().group(MANAGEMENT_GROUP_NAME).pathsToMatch(new String[]{this.apiDocsProperties.getManagementIncludePattern()});
        openApiCustomizers.stream().filter(customizer -> customizer instanceof NamedApiCustomizer && ((NamedApiCustomizer)customizer).getName().equals("management-customizer")).forEach(arg_0 -> ((GroupedOpenApi.Builder)builder).addOpenApiCustomizer(arg_0));
        operationCustomizers.stream().filter(customizer -> !(customizer instanceof ActuatorOperationCustomizer)).forEach(arg_0 -> ((GroupedOpenApi.Builder)builder).addOperationCustomizer(arg_0));
        log.debug("Initialized management group");
        return builder.build();
    }

    private String getVersion() {
        return this.buildProperties.isPresent() ? (String)StringUtils.defaultIfEmpty((CharSequence)this.buildProperties.get().getVersion(), (CharSequence)this.apiDocsProperties.getVersion()) : "Unknown";
    }

    static {
        SpringDocUtils.getConfig().replaceWithClass(ByteBuffer.class, String.class);
    }
}

