/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.config.info;

import com.luixtech.springbootframework.config.LuixProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.core.env.ConfigurableEnvironment;

public class AppInfoContributor
implements InfoContributor {
    private final boolean apiDocsEnabled;
    private final String ribbonProfile;

    public AppInfoContributor(ConfigurableEnvironment env, boolean apiDocsEnabled, LuixProperties luixProperties) {
        this.apiDocsEnabled = apiDocsEnabled;
        String[] profilesArray = env.getActiveProfiles().length == 0 ? env.getDefaultProfiles() : env.getActiveProfiles();
        List<String> displayRibbonOnProfiles = luixProperties.getRibbon().getDisplayOnActiveProfiles();
        if (CollectionUtils.isEmpty(displayRibbonOnProfiles)) {
            this.ribbonProfile = null;
            return;
        }
        Collection intersection = CollectionUtils.intersection(Arrays.asList(profilesArray), displayRibbonOnProfiles);
        this.ribbonProfile = intersection.isEmpty() ? null : (String)intersection.iterator().next();
    }

    public void contribute(Info.Builder builder) {
        builder.withDetail("apiDocsEnabled", (Object)this.apiDocsEnabled);
        builder.withDetail("ribbonProfile", (Object)this.ribbonProfile);
    }
}

