/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.springbootframework.filter;

import com.luixtech.springbootframework.config.LuixProperties;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CachingHttpHeadersFilter
implements Filter {
    private static final long LAST_MODIFIED = System.currentTimeMillis();
    private final LuixProperties luixProperties;
    private long expiredAfter;

    public CachingHttpHeadersFilter(LuixProperties luixProperties) {
        this.luixProperties = luixProperties;
    }

    public void init(FilterConfig filterConfig) {
        this.expiredAfter = TimeUnit.DAYS.toMillis(this.luixProperties.getHttp().getCache().getExpiredAfter());
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setHeader("Cache-Control", "max-age=" + this.expiredAfter + ", public");
        httpResponse.setHeader("Pragma", "cache");
        httpResponse.setDateHeader("Expires", System.currentTimeMillis() + this.expiredAfter);
        httpResponse.setDateHeader("Last-Modified", LAST_MODIFIED);
        chain.doFilter(request, response);
    }
}

