/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.encryption;

import org.apache.commons.lang3.StringUtils;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.PBEConfig;

public abstract class JasyptEncryptUtils {
    public static final String DEFAULT_ALGORITHM = "PBEWithMD5AndDES";
    public static final String DEFAULT_PUBLIC_KEY = "PEB232@2HJ67@HRT78";

    public static String encrypt(String plainText) {
        return JasyptEncryptUtils.encrypt(plainText, DEFAULT_ALGORITHM, DEFAULT_PUBLIC_KEY);
    }

    public static String encrypt(String plainText, String algorithm, String publicKey) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        EnvironmentStringPBEConfig config = new EnvironmentStringPBEConfig();
        config.setAlgorithm((String)StringUtils.defaultIfEmpty((CharSequence)algorithm, (CharSequence)DEFAULT_ALGORITHM));
        config.setPassword((String)StringUtils.defaultIfEmpty((CharSequence)publicKey, (CharSequence)DEFAULT_PUBLIC_KEY));
        encryptor.setConfig((PBEConfig)config);
        return encryptor.encrypt(plainText);
    }

    public static String decrypt(String cipherText) {
        return JasyptEncryptUtils.decrypt(cipherText, DEFAULT_ALGORITHM, DEFAULT_PUBLIC_KEY);
    }

    public static String decrypt(String cipherText, String algorithm, String publicKey) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        EnvironmentStringPBEConfig config = new EnvironmentStringPBEConfig();
        config.setAlgorithm((String)StringUtils.defaultIfEmpty((CharSequence)algorithm, (CharSequence)DEFAULT_ALGORITHM));
        config.setPassword((String)StringUtils.defaultIfEmpty((CharSequence)publicKey, (CharSequence)DEFAULT_PUBLIC_KEY));
        encryptor.setConfig((PBEConfig)config);
        return encryptor.decrypt(cipherText);
    }
}

