/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiClassLoaderObjectInputStream
extends ObjectInputStream {
    private static final Logger log = LoggerFactory.getLogger(MultiClassLoaderObjectInputStream.class);

    public MultiClassLoaderObjectInputStream(InputStream str) throws IOException {
        super(str);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return Class.forName(name, false, cl);
        }
        catch (Throwable ex) {
            log.debug("Cannot access thread context ClassLoader!", ex);
            try {
                ClassLoader cl = MultiClassLoaderObjectInputStream.class.getClassLoader();
                return Class.forName(name, false, cl);
            }
            catch (Throwable ex2) {
                log.debug("Cannot access application ClassLoader", ex2);
                try {
                    ClassLoader cl = ClassLoader.getSystemClassLoader();
                    return Class.forName(name, false, cl);
                }
                catch (Throwable ex3) {
                    log.debug("Cannot access system ClassLoader", ex3);
                    return super.resolveClass(desc);
                }
            }
        }
    }
}

