/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.lang;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MathUtils {
    private static final Logger log = LoggerFactory.getLogger(MathUtils.class);

    public static int parseInt(String intStr, int defaultValue) {
        try {
            return Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse integer!", (Throwable)e);
            return defaultValue;
        }
    }

    public static long parseLong(String longStr, long defaultValue) {
        try {
            return Long.parseLong(longStr);
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse long!", (Throwable)e);
            return defaultValue;
        }
    }

    public static int getNonNegativeVal(int val) {
        return Integer.MAX_VALUE & val;
    }

    public static int getRangedNonNegativeVal(int val) {
        return 0xFFFFFF & val;
    }
}

