/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.lang;

import com.luixtech.utilities.lang.Destroyable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ShutdownHook
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ShutdownHook.class);
    private static final int DEFAULT_PRIORITY = 20;
    private static final ShutdownHook INSTANCE = new ShutdownHook();
    private static final List<CleanableObject> RESOURCES = new ArrayList<CleanableObject>();

    private ShutdownHook() {
    }

    public static synchronized void add(Destroyable destroyable, int priority) {
        RESOURCES.add(new CleanableObject(destroyable, priority));
        log.info("Added the cleanup method of class [{}] to {}", (Object)destroyable.getClass().getSimpleName(), (Object)ShutdownHook.class.getSimpleName());
    }

    public static void add(Destroyable destroyable) {
        ShutdownHook.add(destroyable, 20);
    }

    public static void register() {
        Runtime.getRuntime().addShutdownHook(INSTANCE);
        log.info("Registered the {} to system runtime", (Object)ShutdownHook.class.getSimpleName());
    }

    public static void runNow(boolean sync) {
        if (sync) {
            INSTANCE.run();
        } else {
            INSTANCE.start();
        }
    }

    @Override
    public void run() {
        this.cleanup();
    }

    private synchronized void cleanup() {
        Collections.sort(RESOURCES);
        for (CleanableObject resource : RESOURCES) {
            try {
                resource.destroyable.destroy();
            }
            catch (Exception e) {
                System.out.println("Failed to cleaned up the " + resource.destroyable.getClass().getSimpleName() + " by ShutdownHook with exception: " + e.getMessage());
            }
            System.out.println("Cleaned up the " + resource.destroyable.getClass().getSimpleName() + " by ShutdownHook");
        }
        RESOURCES.clear();
    }

    private static class CleanableObject
    implements Comparable<CleanableObject> {
        private final Destroyable destroyable;
        private final int priority;

        @Override
        public int compareTo(CleanableObject o) {
            return Integer.compare(o.priority, this.priority);
        }

        public CleanableObject(Destroyable destroyable, int priority) {
            this.destroyable = destroyable;
            this.priority = priority;
        }
    }
}

