/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.lang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class ZipUtils {
    public static byte[] gzip(byte[] data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        try (GZIPOutputStream gzip = new GZIPOutputStream(bos);){
            gzip.write(data);
            gzip.finish();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static byte[] unGzip(byte[] data) throws IOException {
        try (GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(data));){
            int size;
            byte[] buf = new byte[2048];
            ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length + 1024);
            while ((size = gzip.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, size);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

