/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.masking;

import org.apache.commons.lang3.StringUtils;

public abstract class MaskingUtils {
    public static String maskChineseName(String lastName, String firstName) {
        if (StringUtils.isBlank((CharSequence)lastName) || StringUtils.isBlank((CharSequence)firstName)) {
            return "";
        }
        return MaskingUtils.maskChineseName(lastName + firstName);
    }

    public static String maskChineseName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.left((String)fullName, (int)1);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }

    public static String maskIdCard(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        return StringUtils.left((String)id, (int)3).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)id, (int)4), (int)StringUtils.length((CharSequence)id), (String)"*"), (String)"***"));
    }

    public static String maskLandlinePhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)StringUtils.length((CharSequence)num), (String)"*");
    }

    public static String maskMobilePhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.left((String)num, (int)3).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)StringUtils.length((CharSequence)num), (String)"*"), (String)"***"));
    }

    public static String maskAddress(String address, int sensitiveCharacterLength) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)address);
        return StringUtils.rightPad((String)StringUtils.left((String)address, (int)(length - sensitiveCharacterLength)), (int)length, (String)"*");
    }

    public static String maskEmail(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)1), (int)index, (String)"*").concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((CharSequence)email)));
    }

    public static String maskBankCard(String cardNum) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        return StringUtils.left((String)cardNum, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)4), (int)StringUtils.length((CharSequence)cardNum), (String)"*"), (String)"******"));
    }

    public static String maskCnapsCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        return StringUtils.rightPad((String)StringUtils.left((String)code, (int)2), (int)StringUtils.length((CharSequence)code), (String)"*");
    }
}

