/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.masking;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.luixtech.utilities.masking.DataMaskingThreadContextHolder;
import com.luixtech.utilities.masking.annotation.SensitiveField;
import com.luixtech.utilities.masking.strategy.Maskable;
import com.luixtech.utilities.serviceloader.ServiceLoader;
import java.io.IOException;
import java.util.Objects;

public class SensitiveWordSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private String sensitiveType;

    public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Maskable maskingStrategy = ServiceLoader.forClass(Maskable.class).load(this.sensitiveType);
        jsonGenerator.writeString(maskingStrategy.mask(value));
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            if (Objects.equals(beanProperty.getType().getRawClass(), String.class)) {
                SensitiveField field = (SensitiveField)beanProperty.getAnnotation(SensitiveField.class);
                if (field == null) {
                    field = (SensitiveField)beanProperty.getContextAnnotation(SensitiveField.class);
                }
                if (field != null && Boolean.TRUE.equals(DataMaskingThreadContextHolder.getMaskEnabled())) {
                    return new SensitiveWordSerializer(field.value());
                }
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(null);
    }

    public SensitiveWordSerializer() {
    }

    public SensitiveWordSerializer(String sensitiveType) {
        this.sensitiveType = sensitiveType;
    }
}

