/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.network;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AddressUtils {
    private static final Logger log = LoggerFactory.getLogger(AddressUtils.class);
    public static final String LOCALHOST = "127.0.0.1";
    public static final String ANY_HOST = "0.0.0.0";
    public static final String INFINITY_IP_PREFIX = "LUIX_IP_PREFIX";
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^\\d{1,3}(\\.\\d{1,3}){3}:\\d{1,5}$");
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static final String COMMA_SEPARATOR = ",";
    private static final int MAX_PORT = 65535;
    private static InetAddress localAddressCache = null;

    public static boolean isValidAddress(String address) {
        return ADDRESS_PATTERN.matcher(address).matches();
    }

    public static boolean isValidIp(String ip) {
        return IP_PATTERN.matcher(ip).matches();
    }

    public static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANY_HOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    public static String getIntranetIp() {
        if (localAddressCache != null) {
            return localAddressCache.getHostAddress();
        }
        InetAddress localAddress = null;
        String ipPrefix = System.getenv(INFINITY_IP_PREFIX);
        if (StringUtils.isNotEmpty((CharSequence)ipPrefix)) {
            localAddress = AddressUtils.getLocalAddressByNetworkInterface(ipPrefix);
            log.info("Found local address [{}] by ip prefix [{}]", (Object)localAddress, (Object)ipPrefix);
        }
        if (!AddressUtils.isValidAddress(localAddress)) {
            localAddress = AddressUtils.getLocalAddressByHostname();
            log.info("Found local address [{}] by hostname", (Object)localAddress);
        }
        if (!AddressUtils.isValidAddress(localAddress)) {
            localAddress = AddressUtils.getLocalAddressByNetworkInterface(null);
            log.info("Found local address [{}] by looping network interfaces", (Object)localAddress);
        }
        if (!AddressUtils.isValidAddress(localAddress)) {
            log.warn("Failed to get local address!");
            return null;
        }
        localAddressCache = localAddress;
        return localAddressCache.getHostAddress();
    }

    private static InetAddress getLocalAddressByNetworkInterface(String prefix) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces == null) {
                return null;
            }
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!AddressUtils.isValidAddress(address)) continue;
                    if (StringUtils.isBlank((CharSequence)prefix)) {
                        return address;
                    }
                    if (!address.getHostAddress().startsWith(prefix)) continue;
                    return address;
                }
            }
        }
        catch (Throwable e) {
            log.warn("Failed to get local ip address", e);
        }
        return null;
    }

    private static InetAddress getLocalAddressByHostname() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (AddressUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Throwable e) {
            log.warn("Failed to get local address by hostname", e);
        }
        return null;
    }

    public static List<Pair<String, Integer>> parseAddress(String address) {
        return Arrays.stream(address.split(COMMA_SEPARATOR)).map(AddressUtils::parseHostPort).collect(Collectors.toList());
    }

    private static Pair<String, Integer> parseHostPort(String addr) {
        String[] hostAndPort = addr.split(":");
        String host = hostAndPort[0].trim();
        int port = Integer.parseInt(hostAndPort[1].trim());
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Illegal port range!");
        }
        return Pair.of((Object)host, (Object)port);
    }

    public static String getHostName(SocketAddress socketAddress) {
        InetAddress addr;
        if (socketAddress == null) {
            return null;
        }
        if (socketAddress instanceof InetSocketAddress && (addr = ((InetSocketAddress)socketAddress).getAddress()) != null) {
            return addr.getHostAddress();
        }
        return null;
    }
}

