/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.notification.wecom;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.luixtech.utilities.notification.wecom.WeComRobotMsgRequest;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.MessageFormat;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WeComUtils {
    private static final Logger log = LoggerFactory.getLogger(WeComUtils.class);
    private static final String ROBOT_WEBHOOK_URL = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key={0}";

    public static HttpResponse<String> sendMessage(String webhookKey, Duration timeout, WeComRobotMsgRequest requestBody) {
        ObjectMapper mapper = new ObjectMapper();
        String requestJson = mapper.writeValueAsString((Object)requestBody);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(MessageFormat.format(ROBOT_WEBHOOK_URL, webhookKey))).timeout(timeout).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestJson)).build();
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        log.info("Sending to WeCom robot with request: {}", (Object)requestJson);
        HttpResponse<String> response = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
        log.info("Sent to WeCom robot with response code: {} and body: {}", (Object)response.statusCode(), (Object)response.body());
        return response;
    }
}

