/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.StringUtils;

@Schema(description="Result object")
public class Result<T> {
    @Schema(description="code", example="SYS0000", required=true)
    private String code;
    @Schema(description="message", example="ok", required=true)
    private String message;
    @Schema(description="data")
    private T data;

    public Result(ResultCode resultCode) {
        this.code = resultCode.getCode();
        this.message = resultCode.getMessage();
    }

    public Result(T data, ResultCode resultCode) {
        this.data = data;
        this.code = resultCode.getCode();
        this.message = resultCode.getMessage();
    }

    public static <T> Result<T> ok(T body) {
        Result<T> result = new Result<T>();
        result.setData(body);
        result.setCode(ResultCode.OK.getCode());
        result.setMessage(ResultCode.OK.getMessage());
        return result;
    }

    public static <T> Result<T> ok() {
        Result<T> result = new Result<T>();
        result.setCode(ResultCode.OK.getCode());
        result.setMessage(ResultCode.OK.getMessage());
        return result;
    }

    public static <T> Result<T> error(String message) {
        Result<T> result = new Result<T>();
        result.setCode(ResultCode.ERROR.getCode());
        result.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.ERROR.getMessage() : message);
        return result;
    }

    public static <T> Result<T> error(ResultCode resultCode, String message) {
        Result<T> result = new Result<T>();
        result.setCode(resultCode.getCode());
        result.setMessage(StringUtils.isEmpty((CharSequence)message) ? resultCode.getMessage() : message);
        return result;
    }

    public static <T> Result<T> illegalArgument(String message) {
        Result<T> result = new Result<T>();
        result.setCode(ResultCode.ILLEGAL_ARG.getCode());
        result.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.ILLEGAL_ARG.getMessage() : message);
        return result;
    }

    public static <T> Result<T> dataNotFound(String message) {
        Result<T> result = new Result<T>();
        result.setCode(ResultCode.DATA_NOT_FOUND.getCode());
        result.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.DATA_NOT_FOUND.getMessage() : message);
        return result;
    }

    public static <T> Result<T> serverError(String message) {
        Result<T> result = new Result<T>();
        result.setCode(ResultCode.INTERNAL_SERVER_ERROR.getCode());
        result.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.INTERNAL_SERVER_ERROR.getMessage() : message);
        return result;
    }

    public static <T> Result<T> requestTimeout(String message) {
        Result<T> result = new Result<T>();
        result.setCode(ResultCode.REQUEST_TIMEOUT.getCode());
        result.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.REQUEST_TIMEOUT.getMessage() : message);
        return result;
    }

    public static <T> Result<T> invocationTimeout(String message) {
        Result<T> result = new Result<T>();
        result.setCode(ResultCode.INVOCATION_TIMEOUT.getCode());
        result.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.INVOCATION_TIMEOUT.getMessage() : message);
        return result;
    }

    public static <T> Result<T> invocationError(String message) {
        Result<T> result = new Result<T>();
        result.setCode(ResultCode.INVOCATION_ERROR.getCode());
        result.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.INVOCATION_ERROR.getMessage() : message);
        return result;
    }

    @JsonIgnore
    public boolean isOk() {
        return ResultCode.OK.getCode().equals(this.getCode());
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + String.valueOf(this.getData()) + ")";
    }

    public Result() {
    }

    public Result(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static enum ResultCode {
        OK("SM1000", "OK"),
        ERROR("EM1000", "Failure"),
        ILLEGAL_ARG("IA1000", "Illegal argument"),
        DATA_NOT_FOUND("IA1002", "Data not found"),
        INTERNAL_SERVER_ERROR("SE1000", "System error"),
        CONCURRENCY_ERROR("SE1002", "Concurrency error"),
        REQUEST_TIMEOUT("SE1003", "Request timeout"),
        INVOCATION_TIMEOUT("SE1004", "Invocation timeout"),
        INVOCATION_ERROR("SE1005", "Invocation error");

        private final String code;
        private final String message;

        private ResultCode(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

