/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.serviceloader;

import com.luixtech.utilities.serviceloader.annotation.Spi;
import com.luixtech.utilities.serviceloader.annotation.SpiName;
import com.luixtech.utilities.serviceloader.annotation.SpiScope;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ServiceLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoader.class);
    private static final String SERVICE_DIR_PREFIX = "META-INF/services/";
    public static final Charset SERVICE_CONFIG_FILE_CHARSET = StandardCharsets.UTF_8;
    private static final Map<String, ServiceLoader<?>> SERVICE_LOADERS_CACHE = new ConcurrentHashMap();
    private final Map<String, T> singletonInstances = new ConcurrentHashMap<String, T>();
    private final ClassLoader classLoader;
    private final Class<T> serviceInterface;
    private final Map<String, Class<T>> serviceImplClasses;

    public static <T> ServiceLoader<T> forClass(Class<T> serviceInterface) {
        Validate.notNull(serviceInterface, (String)"Service interface must not be null!", (Object[])new Object[0]);
        Validate.isTrue((boolean)serviceInterface.isInterface(), (String)"Service interface must be an interface class!", (Object[])new Object[0]);
        Validate.isTrue((boolean)serviceInterface.isAnnotationPresent(Spi.class), (String)"Service interface must be annotated with @Spi annotation!", (Object[])new Object[0]);
        return ServiceLoader.createServiceLoader(serviceInterface);
    }

    private static synchronized <T> ServiceLoader<T> createServiceLoader(Class<T> serviceInterface) {
        ServiceLoader<Object> loader = SERVICE_LOADERS_CACHE.get(serviceInterface.getName());
        if (loader == null) {
            loader = new ServiceLoader<T>(Thread.currentThread().getContextClassLoader(), serviceInterface);
            SERVICE_LOADERS_CACHE.put(serviceInterface.getName(), loader);
        }
        return loader;
    }

    private ServiceLoader(ClassLoader classLoader, Class<T> serviceInterface) {
        this.classLoader = classLoader;
        this.serviceInterface = serviceInterface;
        this.serviceImplClasses = this.loadImplClasses();
    }

    private Map<String, Class<T>> loadImplClasses() {
        String serviceFileName = SERVICE_DIR_PREFIX.concat(this.serviceInterface.getName());
        ArrayList<String> serviceImplClassNames = new ArrayList<String>();
        try {
            Enumeration<URL> fileUrls;
            Enumeration<URL> enumeration = fileUrls = this.classLoader != null ? this.classLoader.getResources(serviceFileName) : ClassLoader.getSystemResources(serviceFileName);
            if (CollectionUtils.sizeIsEmpty(fileUrls)) {
                log.warn("Cannot find the spi configuration file with name {}!", (Object)serviceFileName);
                return Collections.EMPTY_MAP;
            }
            while (fileUrls.hasMoreElements()) {
                this.readImplClassNames(fileUrls.nextElement(), this.serviceInterface, serviceImplClassNames);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load the spi configuration file: ".concat(serviceFileName), e);
        }
        return this.loadImplClass(serviceImplClassNames);
    }

    private void readImplClassNames(URL fileUrl, Class<T> serviceInterface, List<String> implClassNames) {
        int lineNum = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(fileUrl.openStream(), SERVICE_CONFIG_FILE_CHARSET));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.readLine(fileUrl, line, ++lineNum, serviceInterface, implClassNames);
            }
        }
        catch (Exception e) {
            log.error("Failed to read the spi configuration file at line: " + lineNum, (Throwable)e);
        }
    }

    private void readLine(URL fileUrl, String line, int lineNum, Class<T> serviceInterface, List<String> implClassNames) {
        int poundSignIdx = line.indexOf(35);
        if (poundSignIdx >= 0) {
            line = line.substring(0, poundSignIdx);
        }
        if (StringUtils.isEmpty((CharSequence)(line = line.trim()))) {
            return;
        }
        Validate.isTrue((!line.contains(" ") && !line.contains("\t") ? 1 : 0) != 0, (String)("Found illegal space or tab key at line: " + lineNum + " of the file " + String.valueOf(fileUrl)), (Object[])new Object[0]);
        int cp = line.codePointAt(0);
        Validate.isTrue((boolean)Character.isJavaIdentifierStart(cp), (String)("Found illegal service class name at line: " + lineNum + " of the file " + String.valueOf(fileUrl)), (Object[])new Object[0]);
        for (int i = Character.charCount(cp); i < line.length(); i += Character.charCount(cp)) {
            cp = line.codePointAt(i);
            Validate.isTrue((Character.isJavaIdentifierPart(cp) || cp == 46 ? 1 : 0) != 0, (String)("Found illegal service class name at line: " + lineNum + " of the file " + String.valueOf(fileUrl)), (Object[])new Object[0]);
        }
        if (!implClassNames.contains(line)) {
            implClassNames.add(line);
        }
    }

    private Map<String, Class<T>> loadImplClass(List<String> implClassNames) {
        if (CollectionUtils.isEmpty(implClassNames)) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, Class<T>> map = new ConcurrentHashMap<String, Class<T>>(implClassNames.size());
        for (String implClassName : implClassNames) {
            try {
                Class<?> implClass = this.classLoader == null ? Class.forName(implClassName) : Class.forName(implClassName, true, this.classLoader);
                log.debug("Loaded the service instance [{}]", (Object)implClassName);
                this.checkServiceImplClass(implClass);
                String spiName = this.getSpiServiceName(implClass);
                Validate.isTrue((!map.containsKey(spiName) ? 1 : 0) != 0, (String)("Found duplicated SPI name: " + spiName + " for " + implClass.getName()), (Object[])new Object[0]);
                map.put(spiName, implClass);
            }
            catch (Exception e) {
                log.error("Failed to load the spi class: " + implClassName, (Throwable)e);
            }
        }
        return map;
    }

    private void checkServiceImplClass(Class<T> implClass) {
        Validate.isTrue((boolean)Modifier.isPublic(implClass.getModifiers()), (String)(implClass.getName() + " must be public!"), (Object[])new Object[0]);
        Validate.isTrue((boolean)this.serviceInterface.isAssignableFrom(implClass), (String)(implClass.getName() + " must be the implementation of " + this.serviceInterface.getName()), (Object[])new Object[0]);
        this.checkConstructor(implClass);
    }

    private void checkConstructor(Class<T> implClass) {
        Object[] constructors = implClass.getConstructors();
        Validate.notEmpty((Object[])constructors, (String)(implClass.getName() + " has no constructor"), (Object[])new Object[0]);
        for (Object constructor : constructors) {
            if (!Modifier.isPublic(((Constructor)constructor).getModifiers()) || !ArrayUtils.isEmpty((Object[])((Constructor)constructor).getParameterTypes())) continue;
            return;
        }
        throw new IllegalArgumentException(implClass.getName() + " has no public no-args constructor");
    }

    public String getSpiServiceName(Class<?> implClass) {
        SpiName spiName = implClass.getAnnotation(SpiName.class);
        return spiName != null && StringUtils.isNotEmpty((CharSequence)spiName.value()) ? spiName.value() : implClass.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceImplClass(Class<T> implClass) {
        if (implClass == null) {
            return;
        }
        this.checkServiceImplClass(implClass);
        String spiName = this.getSpiServiceName(implClass);
        Map<String, Class<T>> map = this.serviceImplClasses;
        synchronized (map) {
            if (this.serviceImplClasses.containsKey(spiName)) {
                throw new IllegalArgumentException("Already existing the service implementation class with name: " + spiName);
            }
            this.serviceImplClasses.put(spiName, implClass);
        }
    }

    public T load(String name) {
        Validate.notEmpty((CharSequence)name, (String)"Service name must not be empty!", (Object[])new Object[0]);
        try {
            Spi spi = this.serviceInterface.getAnnotation(Spi.class);
            if (SpiScope.SINGLETON.equals((Object)spi.scope())) {
                return this.createSingleton(name);
            }
            return this.createPrototype(name);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load service instance: " + name);
        }
    }

    public List<T> loadAll() {
        ArrayList serviceImpls = new ArrayList(this.serviceImplClasses.size());
        this.serviceImplClasses.keySet().forEach(key -> serviceImpls.add(this.load((String)key)));
        return serviceImpls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T createSingleton(String name) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        T obj = this.singletonInstances.get(name);
        if (obj != null) {
            return obj;
        }
        Class<T> clz = this.serviceImplClasses.get(name);
        if (clz == null) {
            return null;
        }
        Map<String, T> map = this.singletonInstances;
        synchronized (map) {
            obj = this.singletonInstances.get(name);
            if (obj != null) {
                return obj;
            }
            obj = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.singletonInstances.put(name, obj);
        }
        return obj;
    }

    private T createPrototype(String name) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<T> clz = this.serviceImplClasses.get(name);
        if (clz == null) {
            return null;
        }
        return clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

