/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.thread;

import org.apache.commons.lang3.Validate;

public final class Throttler {
    private long throttleBatchSize;
    private long nanosPerBatch;
    private long endOfNextBatchNanos;
    private int currentBatch;

    public Throttler(long maxRecordsPerSecond, int numberOfParallelSubtasks) {
        this.setup(maxRecordsPerSecond, numberOfParallelSubtasks);
    }

    public void adjustMaxRecordsPerSecond(long maxRecordsPerSecond) {
        this.setup(maxRecordsPerSecond, 1);
    }

    private void setup(long maxRecordsPerSecond, int numberOfParallelSubtasks) {
        Validate.isTrue((maxRecordsPerSecond == -1L || maxRecordsPerSecond > 0L ? 1 : 0) != 0, (String)"maxRecordsPerSecond must be positive or -1 (infinite)", (Object[])new Object[0]);
        Validate.isTrue((numberOfParallelSubtasks > 0 ? 1 : 0) != 0, (String)"numberOfParallelSubtasks must be greater than 0", (Object[])new Object[0]);
        if (maxRecordsPerSecond == -1L) {
            this.throttleBatchSize = -1L;
            this.nanosPerBatch = 0L;
            this.endOfNextBatchNanos = System.nanoTime() + this.nanosPerBatch;
            this.currentBatch = 0;
            return;
        }
        float ratePerSubtask = (float)maxRecordsPerSecond / (float)numberOfParallelSubtasks;
        if (ratePerSubtask >= 10000.0f) {
            this.throttleBatchSize = (int)ratePerSubtask / 500;
            this.nanosPerBatch = 2000000L;
        } else {
            this.throttleBatchSize = (int)(ratePerSubtask / 20.0f) + 1;
            this.nanosPerBatch = (long)((int)(1.0E9f / ratePerSubtask)) * this.throttleBatchSize;
        }
        this.endOfNextBatchNanos = System.nanoTime() + this.nanosPerBatch;
        this.currentBatch = 0;
    }

    public void throttle() throws InterruptedException {
        if (this.throttleBatchSize == -1L) {
            return;
        }
        if ((long)(++this.currentBatch) != this.throttleBatchSize) {
            return;
        }
        this.currentBatch = 0;
        long now = System.nanoTime();
        int millisRemaining = (int)((this.endOfNextBatchNanos - now) / 1000000L);
        if (millisRemaining > 0) {
            this.endOfNextBatchNanos += this.nanosPerBatch;
            Thread.sleep(millisRemaining);
        } else {
            this.endOfNextBatchNanos = now + this.nanosPerBatch;
        }
    }
}

