/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.thread.pool;

import com.luixtech.utilities.thread.pool.NetworkThreadPoolExecutor;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionException;

class ExecutorQueue
extends LinkedTransferQueue<Runnable> {
    private static final long serialVersionUID = 1693153562045930859L;
    private NetworkThreadPoolExecutor threadPoolExecutor;

    public void setStandardThreadExecutor(NetworkThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public boolean force(Runnable o) {
        if (this.threadPoolExecutor.isShutdown()) {
            throw new RejectedExecutionException("Can NOT insert a task into the queue after the executor shutdown!");
        }
        return super.offer(o);
    }

    @Override
    public boolean offer(Runnable o) {
        int poolSize = this.threadPoolExecutor.getPoolSize();
        if (poolSize == this.threadPoolExecutor.getMaximumPoolSize()) {
            return super.offer(o);
        }
        if (this.threadPoolExecutor.getSubmittedTasksCount() <= poolSize) {
            return super.offer(o);
        }
        if (poolSize < this.threadPoolExecutor.getMaximumPoolSize()) {
            return false;
        }
        return super.offer(o);
    }
}

