/*
 * Decompiled with CFR 0.152.
 */
package com.luixtech.utilities.thread.pool;

import com.luixtech.utilities.thread.pool.ExecutorQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class NetworkThreadPoolExecutor
extends ThreadPoolExecutor {
    public static final int DEFAULT_CORE_POOL_SIZE = 20;
    public static final int DEFAULT_MAX_POOL_SIZE = 200;
    public static final int DEFAULT_KEEP_ALIVE_TIME = 60000;
    protected AtomicInteger submittedTasksCount = new AtomicInteger(0);
    private final int maxSubmittedTasksCount;

    public NetworkThreadPoolExecutor() {
        this(20, 200);
    }

    public NetworkThreadPoolExecutor(int corePoolSize, int maximumPoolSize) {
        this(corePoolSize, maximumPoolSize, maximumPoolSize);
    }

    public NetworkThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, maximumPoolSize);
    }

    public NetworkThreadPoolExecutor(int corePoolSize, int maximumPoolSize, int queueCapacity) {
        this(corePoolSize, maximumPoolSize, queueCapacity, Executors.defaultThreadFactory());
    }

    public NetworkThreadPoolExecutor(int corePoolSize, int maximumPoolSize, int queueCapacity, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, 60000L, TimeUnit.MILLISECONDS, queueCapacity, threadFactory);
    }

    public NetworkThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int queueCapacity) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, queueCapacity, Executors.defaultThreadFactory());
    }

    public NetworkThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int queueCapacity, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, queueCapacity, threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
    }

    public NetworkThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int queueCapacity, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new ExecutorQueue(), threadFactory, handler);
        ((ExecutorQueue)this.getQueue()).setStandardThreadExecutor(this);
        this.maxSubmittedTasksCount = queueCapacity + maximumPoolSize;
    }

    @Override
    public void execute(Runnable command) {
        block3: {
            int count = this.submittedTasksCount.incrementAndGet();
            if (count > this.maxSubmittedTasksCount) {
                this.submittedTasksCount.decrementAndGet();
                this.getRejectedExecutionHandler().rejectedExecution(command, this);
            }
            try {
                super.execute(command);
            }
            catch (RejectedExecutionException rx) {
                if (((ExecutorQueue)this.getQueue()).force(command)) break block3;
                this.submittedTasksCount.decrementAndGet();
                this.getRejectedExecutionHandler().rejectedExecution(command, this);
            }
        }
    }

    public int getSubmittedTasksCount() {
        return this.submittedTasksCount.get();
    }

    public int getMaxSubmittedTasksCount() {
        return this.maxSubmittedTasksCount;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.submittedTasksCount.decrementAndGet();
    }
}

