/*
 * Decompiled with CFR 0.152.
 */
package com.lukekorth.ez_loaders;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.LocalBroadcastManager;
import com.lukekorth.ez_loaders.EzLoaderInterface;

public class EzLoader<T>
extends AsyncTaskLoader<T> {
    private BroadcastReceiver mBroadcastReceiver;
    private String mBroadcastAction;
    private boolean mUseLocalBroadcastManager;
    private EzLoaderInterface<T> mLoaderInterface;
    private T mT;

    public EzLoader(Context context, String broadcastAction, EzLoaderInterface<T> loaderInterface) {
        super(context);
        this.mBroadcastAction = broadcastAction;
        this.mUseLocalBroadcastManager = false;
        this.mLoaderInterface = loaderInterface;
    }

    public EzLoader(Context context, String broadcastAction, boolean useLocalBroadcastManager, EzLoaderInterface<T> loaderInterface) {
        super(context);
        this.mBroadcastAction = broadcastAction;
        this.mUseLocalBroadcastManager = useLocalBroadcastManager;
        this.mLoaderInterface = loaderInterface;
    }

    public T loadInBackground() {
        return this.mLoaderInterface.loadInBackground(this.getId());
    }

    public void deliverResult(T t) {
        if (this.isReset() && t != null) {
            this.onReleaseResources(t);
            return;
        }
        T oldT = this.mT;
        this.mT = t;
        if (this.isStarted()) {
            super.deliverResult(t);
        }
        if (oldT != null && oldT != t) {
            this.onReleaseResources(oldT);
        }
    }

    protected void onStartLoading() {
        if (this.mT != null) {
            this.deliverResult(this.mT);
        }
        if (this.mBroadcastReceiver == null) {
            IntentFilter filter = new IntentFilter();
            filter.addAction(this.mBroadcastAction);
            this.mBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    EzLoader.this.onContentChanged();
                }
            };
            if (this.mUseLocalBroadcastManager) {
                LocalBroadcastManager.getInstance((Context)this.getContext()).registerReceiver(this.mBroadcastReceiver, filter);
            } else {
                this.getContext().registerReceiver(this.mBroadcastReceiver, filter);
            }
        }
        if (this.takeContentChanged()) {
            this.forceLoad();
        } else if (this.mT == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    protected void onReset() {
        this.onStopLoading();
        if (this.mT != null) {
            this.onReleaseResources(this.mT);
            this.mT = null;
        }
        if (this.mBroadcastReceiver != null) {
            if (this.mUseLocalBroadcastManager) {
                LocalBroadcastManager.getInstance((Context)this.getContext()).unregisterReceiver(this.mBroadcastReceiver);
            } else {
                this.getContext().unregisterReceiver(this.mBroadcastReceiver);
            }
            this.mBroadcastReceiver = null;
        }
    }

    public void onCanceled(T t) {
        super.onCanceled(t);
        this.onReleaseResources(t);
    }

    public void forceLoad() {
        super.forceLoad();
    }

    private void onReleaseResources(T t) {
        this.mLoaderInterface.onReleaseResources(t);
    }
}

