/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxb;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxb.JSONConvention;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import java.util.regex.Pattern;

public class JAXBConfiguration
extends JAXConfiguration {
    public boolean enableJSONTypeName;
    public Pattern onlyOutputJAXBClassPackagesMatching;
    public boolean enableJaxBMethodOutput = true;
    public boolean enableJSONExample = true;
    public boolean enableXMLExample = true;
    public JSONConvention jsonConvention = JSONConvention.JETTISON_MAPPED;

    public JAXBConfiguration(ConfigurationImpl conf) {
        super(conf);
    }

    public void setOptions() {
        super.setOptions();
        String[][] options = this.parentConfiguration.root.options();
        String pattern = Utils.getOption(options, "-matchingjaxbnamesonly");
        if (pattern != null) {
            this.onlyOutputJAXBClassPackagesMatching = Pattern.compile(pattern);
        }
        this.enableJaxBMethodOutput = !Utils.hasOption(options, "-disablejaxbmethodoutput");
        this.enableJSONTypeName = !Utils.hasOption(options, "-disablejsontypename");
        this.enableJSONExample = !Utils.hasOption(options, "-disablejsonexample");
        this.enableXMLExample = !Utils.hasOption(options, "-disablexmlexample");
        String jsonConvention = Utils.getOption(options, "-jsonconvention");
        if (jsonConvention == null || "jettison".equals(jsonConvention)) {
            this.jsonConvention = JSONConvention.JETTISON_MAPPED;
        } else if ("badgerfish".equals(jsonConvention)) {
            this.jsonConvention = JSONConvention.BADGERFISH;
        } else if ("mapped".equals(jsonConvention)) {
            this.jsonConvention = JSONConvention.MAPPED;
        } else {
            this.parentConfiguration.root.printError("Unknown JSON convention: " + jsonConvention + " (must be one of 'jettison' (default), 'badgerfish', 'mapped')");
        }
    }
}

