/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSDoclet;
import com.lunatech.doclets.jax.jaxrs.model.JAXRSApplication;
import com.lunatech.doclets.jax.jaxrs.model.PojoTypes;
import com.lunatech.doclets.jax.jaxrs.writers.DocletWriter;
import com.lunatech.doclets.jax.jaxrs.writers.JAXRSHtmlDocletWriter;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectIndexWriter
extends DocletWriter {
    private PojoTypes pojoTypes;

    public DataObjectIndexWriter(JAXConfiguration configuration, JAXRSApplication application, JAXRSDoclet doclet, PojoTypes types) {
        super(configuration, DataObjectIndexWriter.getWriter(configuration, application), application, application.getRootResource(), doclet);
        this.pojoTypes = types;
    }

    private static HtmlDocletWriter getWriter(JAXConfiguration configuration, JAXRSApplication application) {
        try {
            return new JAXRSHtmlDocletWriter(application, configuration, "", "objects-index.html", "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        this.printPrelude("Data object index", "Data objects");
        Comparator<Type> typeSimpleNameComparator = new Comparator<Type>(){

            @Override
            public int compare(Type t0, Type t1) {
                return t0.simpleTypeName().compareTo(t1.simpleTypeName());
            }
        };
        ArrayList<ClassDoc> resolvedClasses = new ArrayList<ClassDoc>(this.pojoTypes.getResolvedTypes());
        Collections.sort(resolvedClasses, typeSimpleNameComparator);
        this.printClasses(resolvedClasses);
        this.tag("hr");
        this.printPostlude("Data objects");
        this.writer.flush();
        this.writer.close();
    }

    private void printClasses(Collection<Type> classes) {
        this.tag("hr");
        this.open("table class='info'");
        this.around("caption class='TableCaption'", "Elements");
        this.open("tbody");
        this.open("tr");
        this.around("th class='TableHeader'", "Data Type");
        this.around("th class='TableHeader DescriptionHeader'", "Description");
        this.close("tr");
        for (Type klass : classes) {
            ClassDoc cDoc = klass.asClassDoc();
            this.open("tr");
            this.open("td");
            if (cDoc != null) {
                this.around("a title='" + cDoc.qualifiedTypeName() + "' + href='" + this.writer.relativePath + DataObjectIndexWriter.getLink(cDoc) + "'", cDoc.simpleTypeName());
                ClassDoc superClass = cDoc.superclass();
                if (this.pojoTypes.getResolvedTypes().contains(superClass)) {
                    this.open("span class='typedetail'");
                    this.print(" extends ");
                    this.around("a title='" + superClass.qualifiedTypeName() + "' href='" + this.writer.relativePath + DataObjectIndexWriter.getLink(superClass) + "'", superClass.simpleTypeName());
                    this.close("span");
                } else if (cDoc.isEnum()) {
                    this.open("span class='typedetail'");
                    this.print(" (Enumeration)");
                    this.close("span");
                }
            } else {
                this.print(klass.simpleTypeName());
            }
            this.close("td");
            this.open("td");
            if (cDoc != null) {
                this.writer.printSummaryComment((Doc)cDoc);
            }
            this.close("td");
            this.close("tr");
        }
        this.close("tbody");
        this.close("table");
    }

    static String getLink(ClassDoc type) {
        return Utils.classToPath(type) + "/" + type.typeName() + ".html";
    }
}

