/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.sun.javadoc.Doc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;

public class DocletWriter {
    private static final String VERSION = "0.10.0";
    protected HtmlDocletWriter writer;
    protected JAXConfiguration configuration;

    public DocletWriter(JAXConfiguration configuration, HtmlDocletWriter writer) {
        this.writer = writer;
        this.configuration = configuration;
    }

    public HtmlDocletWriter getWriter() {
        return this.writer;
    }

    public JAXConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void open(String ... tags) {
        for (String tag : tags) {
            this.print("<" + tag + ">");
        }
    }

    protected void close(String ... tags) {
        for (String tag : tags) {
            this.print("</" + tag + ">");
        }
    }

    protected void tag(String ... tags) {
        for (String tag : tags) {
            this.print("<" + tag + "/>");
        }
    }

    protected void around(String tag, String value) {
        this.open(tag);
        this.print(value);
        int space = tag.indexOf(32);
        if (space > -1) {
            tag = tag.substring(0, space);
        }
        this.close(tag);
    }

    protected void printLink(boolean hasLink, String href, String text) {
        if (!hasLink) {
            this.print(text);
        } else {
            this.around("a href='" + href + "'", text);
        }
    }

    protected void printHeader(String title) {
        this.open("!DOCTYPE html");
        this.open("HTML");
        this.open("HEAD");
        this.around("TITLE", title);
        this.tag("LINK REL='stylesheet' TYPE='text/css' HREF='" + this.writer.relativePath + "doclet.css' TITLE='Style'");
        String charset = this.configuration.parentConfiguration.charset;
        if (Utils.isEmptyOrNull(charset)) {
            charset = "UTF-8";
        }
        this.print("<META http-equiv=\"Content-Type\" content=\"text/html; charset=" + charset + "\">\n");
        this.printAdditionalHeader();
        this.close("HEAD");
        this.open("BODY");
        String msg = this.configuration.parentConfiguration.header;
        if (msg != null) {
            this.print(this.writer.replaceDocRootDir(msg));
        }
    }

    protected void printAdditionalHeader() {
    }

    protected void printFooter() {
        String msg = this.configuration.parentConfiguration.footer;
        if (msg != null) {
            this.print(this.writer.replaceDocRootDir(msg));
        }
        this.tag("hr");
        this.open("div class='footer'");
        this.print("Generated by <a href='http://www.lunatech-labs.com/open-source/jax-doclets'>Lunatech Labs jax-doclets</a> v0.10.0");
        this.close("div");
        this.close("BODY");
        this.close("HTML");
    }

    protected void printMenu(String selected) {
        this.printMenu(selected, null);
    }

    protected void printMenu(String selected, String subStyle) {
        if (!this.configuration.parentConfiguration.nonavbar) {
            this.open("table class='menu " + (subStyle != null ? "menu-" + subStyle : "") + "'", "colgroup");
            this.tag("col", "col");
            this.close("colgroup");
            this.open("tbody", "tr");
            this.open("td class='NavBarCell1' colspan='2'");
            this.printTopMenu(selected);
            this.close("td", "tr");
            this.printThirdMenu();
            this.close("table");
        }
    }

    protected void printThirdMenu() {
    }

    protected void printTopMenu(String selected) {
        this.open("table", "tbody", "tr");
        this.printMenuItem("Overview", this.writer.relativePath + "overview-summary.html", selected);
        this.printOtherMenuItems(selected);
        this.close("tr", "tbody", "table");
    }

    protected void printOtherMenuItems(String selected) {
    }

    protected void printMenuItem(String title, String href, String selected) {
        boolean isSelected = title.equals(selected);
        if (isSelected) {
            this.open("th class='selected'");
        } else {
            this.open("th");
        }
        if (href != null && !isSelected) {
            this.around("a href='" + href + "'", title);
        } else {
            this.print(title);
        }
        this.close("th");
    }

    protected void print(String str) {
        this.writer.write(str);
    }

    protected String escape(String str) {
        return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    protected void printSeeAlso(Doc javaDoc) {
        SeeTag[] seeTags = javaDoc.seeTags();
        if (seeTags != null && seeTags.length > 0) {
            this.open("dl class='seealso'");
            this.around("dt", "See Also:");
            this.open("dd");
            for (int i = 0; i < seeTags.length; ++i) {
                SeeTag seeTag = seeTags[i];
                this.writer.printSummaryComment(javaDoc, (Tag[])new SeeTag[]{seeTag});
                if (i >= seeTags.length - 1) continue;
                this.writer.write(", ");
            }
            this.close("dd", "dl");
        }
    }

    protected void printSince(Doc javaDoc) {
        Tag[] sinceTags = javaDoc.tags("since");
        if (sinceTags != null && sinceTags.length > 0) {
            this.open("dl class='since'");
            this.around("dt", "Since:");
            this.open("dd");
            this.writer.write(sinceTags[0].text());
            this.close("dd", "dl");
        }
    }
}

