/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind;

import com.lvonce.wind.converter.Converter;
import com.lvonce.wind.converter.LocalDateTimeConverterMap;
import com.lvonce.wind.converter.StringConverterMap;
import java.util.Arrays;

public class ConverterBuilder {
    public static Converter genTypeConverter(TypeConverterBuildArg buildArg) {
        String converterName;
        if (buildArg == null) {
            return null;
        }
        switch (converterName = buildArg.sourceType + "To" + buildArg.targetType) {
            case "StringToByte": {
                return StringConverterMap.getFromStrConverter("String", "Byte");
            }
            case "StringToShort": {
                return StringConverterMap.getFromStrConverter("String", "Short");
            }
            case "StringToInt": {
                return StringConverterMap.getFromStrConverter("String", "Int");
            }
            case "StringToLong": {
                return StringConverterMap.getFromStrConverter("String", "Long");
            }
            case "StringToFloat": {
                return StringConverterMap.getFromStrConverter("String", "Float");
            }
            case "StringToDouble": {
                return StringConverterMap.getFromStrConverter("String", "Double");
            }
            case "StringToBigDecimal": {
                return StringConverterMap.getFromStrConverter("String", "BigDecimal");
            }
            case "StringToBoolean": {
                return StringConverterMap.getFromStrConverter("String", "Boolean");
            }
            case "ToString": {
                return StringConverterMap.getToStrConverter();
            }
            case "LocalDateTimeToString": {
                return LocalDateTimeConverterMap.getToStrConverter(buildArg.args[0]);
            }
            case "StringToLocalDateTime": {
                return LocalDateTimeConverterMap.getFromStrConverter(buildArg.args[0]);
            }
        }
        throw new RuntimeException("");
    }

    public static class TypeConverterBuildArg {
        private String sourceType;
        private String targetType;
        private String[] args;

        public TypeConverterBuildArg(String sourceType, String targetType, String ... args) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.args = args;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getTargetType() {
            return this.targetType;
        }

        public String[] getArgs() {
            return this.args;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeConverterBuildArg)) {
                return false;
            }
            TypeConverterBuildArg other = (TypeConverterBuildArg)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sourceType = this.getSourceType();
            String other$sourceType = other.getSourceType();
            if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
                return false;
            }
            String this$targetType = this.getTargetType();
            String other$targetType = other.getTargetType();
            if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
                return false;
            }
            return Arrays.deepEquals(this.getArgs(), other.getArgs());
        }

        protected boolean canEqual(Object other) {
            return other instanceof TypeConverterBuildArg;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourceType = this.getSourceType();
            result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
            String $targetType = this.getTargetType();
            result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArgs());
            return result;
        }

        public String toString() {
            return "ConverterBuilder.TypeConverterBuildArg(sourceType=" + this.getSourceType() + ", targetType=" + this.getTargetType() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
        }
    }
}

