/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind;

import com.lvonce.wind.RestFunction;
import com.lvonce.wind.RestRouter;
import com.lvonce.wind.RestSqlContextImpl;
import com.lvonce.wind.SQLDataSourceManager;
import com.lvonce.wind.factory.RestFunctionFactory;
import com.lvonce.wind.http.HttpMethod;
import com.lvonce.wind.http.HttpRequest;
import com.lvonce.wind.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestFunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(RestFunctionExecutor.class);
    private final SQLDataSourceManager dataSourceManager;
    private final RestRouter restRouter;
    private final RestFunctionFactory factory;

    public RestFunctionExecutor(SQLDataSourceManager dataSourceManager, RestRouter restRouter, RestFunctionFactory factory) {
        this.dataSourceManager = dataSourceManager;
        this.restRouter = restRouter;
        this.factory = factory;
    }

    public boolean shouldIntercept(String url, HttpMethod method) {
        return this.restRouter.hasHandler(url, method);
    }

    public HttpResponse apply(String url, HttpMethod method, HttpRequest request) throws Exception {
        RestSqlContextImpl context = new RestSqlContextImpl(this.dataSourceManager.getSqlDataSource(), request.getHeaders(), request.getParams(), request.getBody());
        String handlerName = this.restRouter.getHandler(url, method);
        RestFunction func = this.factory.getFunction(handlerName);
        func.apply(method.toString(), context);
        return context.getResponse();
    }
}

