/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind;

import com.lvonce.wind.Pair;
import com.lvonce.wind.http.HttpMethod;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRouter {
    private static final Logger log = LoggerFactory.getLogger(RestRouter.class);
    private final LinkedHashMap<Pair<String, HttpMethod>, String> restBindMap = new LinkedHashMap();

    @Inject
    public RestRouter(RouterConfig routerConfig) {
        for (RouterItem item : routerConfig.routers) {
            Pair<String, HttpMethod> key = Pair.of(item.url, HttpMethod.from(item.method));
            this.restBindMap.put(key, item.handler);
        }
    }

    public void update(RouterConfig routerConfig) {
        this.restBindMap.clear();
        for (RouterItem item : routerConfig.routers) {
            Pair<String, HttpMethod> key = Pair.of(item.url, HttpMethod.from(item.method));
            this.restBindMap.put(key, item.handler);
        }
    }

    public boolean hasHandler(String url, HttpMethod method) {
        return this.restBindMap.get(Pair.of(url, method)) != null;
    }

    public String getHandler(String url, HttpMethod method) {
        return this.restBindMap.get(Pair.of(url, method));
    }

    public static class RouterConfig {
        List<RouterItem> routers;

        public List<RouterItem> getRouters() {
            return this.routers;
        }

        public void setRouters(List<RouterItem> routers) {
            this.routers = routers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RouterConfig)) {
                return false;
            }
            RouterConfig other = (RouterConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<RouterItem> this$routers = this.getRouters();
            List<RouterItem> other$routers = other.getRouters();
            return !(this$routers == null ? other$routers != null : !((Object)this$routers).equals(other$routers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RouterConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<RouterItem> $routers = this.getRouters();
            result = result * 59 + ($routers == null ? 43 : ((Object)$routers).hashCode());
            return result;
        }

        public String toString() {
            return "RestRouter.RouterConfig(routers=" + this.getRouters() + ")";
        }
    }

    public static class RouterItem {
        String url;
        String method;
        String handler;

        public String getUrl() {
            return this.url;
        }

        public String getMethod() {
            return this.method;
        }

        public String getHandler() {
            return this.handler;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setHandler(String handler) {
            this.handler = handler;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RouterItem)) {
                return false;
            }
            RouterItem other = (RouterItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$handler = this.getHandler();
            String other$handler = other.getHandler();
            return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RouterItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $handler = this.getHandler();
            result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
            return result;
        }

        public String toString() {
            return "RestRouter.RouterItem(url=" + this.getUrl() + ", method=" + this.getMethod() + ", handler=" + this.getHandler() + ")";
        }
    }
}

