/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.PreparedStatement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDataSourceManager {
    private static final Logger log = LoggerFactory.getLogger(SQLDataSourceManager.class);
    private final LinkedHashMap<String, DataSource> sqlDataSource = new LinkedHashMap();

    public void setConfig(SQLDataSourceConfig dataSourceConfig) {
        this.sqlDataSource.clear();
        for (SQLDataSourceConfigItem item : dataSourceConfig.getSources()) {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(item.url);
            config.setUsername(item.username);
            config.setPassword(item.password);
            config.addDataSourceProperty("cachePrepStmts", (Object)true);
            HikariDataSource ds = new HikariDataSource(config);
            this.sqlDataSource.put(item.name, (DataSource)ds);
            if (item.tables != null) {
                for (String table : item.tables) {
                    this.executeSql(item.name, table);
                }
            }
            if (item.data == null) continue;
            for (String d : item.data) {
                this.executeSql(item.name, d);
            }
        }
    }

    @Inject
    public SQLDataSourceManager(SQLDataSourceConfig config) {
        this.setConfig(config);
    }

    public void update(SQLDataSourceConfig config) {
        this.sqlDataSource.clear();
        this.setConfig(config);
    }

    public void executeSql(String name, String sql) {
        try {
            DataSource ds = this.sqlDataSource.get(name);
            PreparedStatement createTableStmt = ds.getConnection().prepareStatement(sql);
            createTableStmt.executeUpdate();
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    public LinkedHashMap<String, DataSource> getSqlDataSource() {
        return this.sqlDataSource;
    }

    public static class SQLDataSourceConfigItem {
        String name;
        String url;
        String username;
        String password;
        Map<String, Object> properties;
        List<String> tables;
        List<String> data;

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public List<String> getTables() {
            return this.tables;
        }

        public List<String> getData() {
            return this.data;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        public void setTables(List<String> tables) {
            this.tables = tables;
        }

        public void setData(List<String> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SQLDataSourceConfigItem)) {
                return false;
            }
            SQLDataSourceConfigItem other = (SQLDataSourceConfigItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            Map<String, Object> this$properties = this.getProperties();
            Map<String, Object> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            List<String> this$tables = this.getTables();
            List<String> other$tables = other.getTables();
            if (this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables)) {
                return false;
            }
            List<String> this$data = this.getData();
            List<String> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SQLDataSourceConfigItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            Map<String, Object> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            List<String> $tables = this.getTables();
            result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
            List<String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "SQLDataSourceManager.SQLDataSourceConfigItem(name=" + this.getName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", properties=" + this.getProperties() + ", tables=" + this.getTables() + ", data=" + this.getData() + ")";
        }
    }

    public static class SQLDataSourceConfig {
        List<SQLDataSourceConfigItem> sources;

        public List<SQLDataSourceConfigItem> getSources() {
            return this.sources;
        }

        public void setSources(List<SQLDataSourceConfigItem> sources) {
            this.sources = sources;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SQLDataSourceConfig)) {
                return false;
            }
            SQLDataSourceConfig other = (SQLDataSourceConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<SQLDataSourceConfigItem> this$sources = this.getSources();
            List<SQLDataSourceConfigItem> other$sources = other.getSources();
            return !(this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SQLDataSourceConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<SQLDataSourceConfigItem> $sources = this.getSources();
            result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
            return result;
        }

        public String toString() {
            return "SQLDataSourceManager.SQLDataSourceConfig(sources=" + this.getSources() + ")";
        }
    }
}

