/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind;

import com.lvonce.wind.validator.ChineseCellphoneValidator;
import com.lvonce.wind.validator.EmailValidator;
import com.lvonce.wind.validator.EnumStrValidator;
import com.lvonce.wind.validator.LengthValidator;
import com.lvonce.wind.validator.MinMaxRange;
import com.lvonce.wind.validator.NumberValidator;
import com.lvonce.wind.validator.Validator;
import com.lvonce.wind.validator.logic.LogicAnd;
import com.lvonce.wind.validator.logic.LogicNot;
import com.lvonce.wind.validator.logic.LogicOr;
import java.util.Arrays;

public class ValidatorBuilder {
    static Integer parseToInt(Object val) {
        if (val instanceof String) {
            return Integer.parseInt((String)val);
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return null;
    }

    public static Validator genValidator(ValidatorBuildArg buildArg) {
        if (buildArg == null) {
            return null;
        }
        switch (buildArg.validatorName) {
            case "And": {
                Validator[] andValidator = new Validator[buildArg.args.length];
                for (int i = 0; i < buildArg.args.length; ++i) {
                    andValidator[i] = ValidatorBuilder.genValidator((ValidatorBuildArg)buildArg.args[i]);
                }
                return new LogicAnd(andValidator);
            }
            case "Or": {
                Validator[] orValidators = new Validator[buildArg.args.length];
                for (int i = 0; i < buildArg.args.length; ++i) {
                    orValidators[i] = ValidatorBuilder.genValidator((ValidatorBuildArg)buildArg.args[i]);
                }
                return new LogicOr(orValidators);
            }
            case "Not": {
                Validator notValidators = ValidatorBuilder.genValidator((ValidatorBuildArg)buildArg.args[0]);
                return new LogicNot(notValidators);
            }
            case "Email": {
                return new EmailValidator();
            }
            case "Number": {
                return new NumberValidator();
            }
            case "ChineseCellphone": {
                return new ChineseCellphoneValidator();
            }
            case "EnumString": {
                return new EnumStrValidator((String[])buildArg.args);
            }
            case "Length": {
                if (buildArg.args.length == 1) {
                    int len = ValidatorBuilder.parseToInt(buildArg.args[0]);
                    return new LengthValidator(len, len);
                }
                if (buildArg.args.length == 2) {
                    int min = ValidatorBuilder.parseToInt(buildArg.args[0]);
                    int max = ValidatorBuilder.parseToInt(buildArg.args[1]);
                    return new LengthValidator(min, max);
                }
                return null;
            }
            case "Range": {
                if (buildArg.args.length == 2) {
                    Comparable min = (Comparable)buildArg.args[0];
                    Comparable max = (Comparable)buildArg.args[1];
                    return new MinMaxRange<Comparable>(min, max);
                }
                return null;
            }
        }
        return null;
    }

    public static class ValidatorBuildArg {
        private String validatorName;
        private Object[] args;

        public ValidatorBuildArg(String validatorName, Object ... args) {
            this.validatorName = validatorName;
            this.args = args;
        }

        public String getValidatorName() {
            return this.validatorName;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public void setValidatorName(String validatorName) {
            this.validatorName = validatorName;
        }

        public void setArgs(Object[] args) {
            this.args = args;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValidatorBuildArg)) {
                return false;
            }
            ValidatorBuildArg other = (ValidatorBuildArg)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$validatorName = this.getValidatorName();
            String other$validatorName = other.getValidatorName();
            if (this$validatorName == null ? other$validatorName != null : !this$validatorName.equals(other$validatorName)) {
                return false;
            }
            return Arrays.deepEquals(this.getArgs(), other.getArgs());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValidatorBuildArg;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $validatorName = this.getValidatorName();
            result = result * 59 + ($validatorName == null ? 43 : $validatorName.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArgs());
            return result;
        }

        public String toString() {
            return "ValidatorBuilder.ValidatorBuildArg(validatorName=" + this.getValidatorName() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
        }
    }
}

