/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind;

import com.lvonce.wind.RestFunctionExecutor;
import com.lvonce.wind.http.HttpMethod;
import com.lvonce.wind.http.HttpRequest;
import com.lvonce.wind.http.HttpRequestBody;
import com.lvonce.wind.http.HttpResponse;
import com.lvonce.wind.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WindWebFilter
implements Filter {
    private final RestFunctionExecutor executor;

    private HttpRequest translate(HttpServletRequest httpServletRequest) throws IOException {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String header = httpServletRequest.getHeader(headerName);
            headers.put(headerName, header);
        }
        Map parameterMap = httpServletRequest.getParameterMap();
        HttpRequestBody body = new HttpRequestBody((InputStream)httpServletRequest.getInputStream());
        return new HttpRequest(headers, parameterMap, body);
    }

    private String stringify(HttpResponse response) {
        LinkedHashMap<String, Object> responseMap = new LinkedHashMap<String, Object>();
        if (response.getErrCode().equalsIgnoreCase("0")) {
            responseMap.put("success", true);
            responseMap.put("errCode", response.getErrCode());
            responseMap.put("errMessage", response.getErrMessage());
            responseMap.put("data", response.getBody());
        } else {
            responseMap.put("success", false);
            responseMap.put("errCode", response.getErrCode());
            responseMap.put("errMessage", response.getErrMessage());
        }
        return JsonUtil.toJson(responseMap, "");
    }

    private void output(HttpServletResponse servletResponse, HttpResponse response) throws IOException {
        Map<String, String> headers = response.getHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            servletResponse.addHeader(entry.getKey(), entry.getValue());
        }
        Map<String, String> cookieMap = response.getCookies();
        for (Map.Entry<String, String> entry : cookieMap.entrySet()) {
            Cookie cookie = new Cookie(entry.getKey(), entry.getValue());
            servletResponse.addCookie(cookie);
        }
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setContentType("application/json; charset=utf-8");
        PrintWriter printWriter = servletResponse.getWriter();
        ((Writer)printWriter).write(this.stringify(response));
        ((Writer)printWriter).flush();
        ((Writer)printWriter).close();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            System.out.println(request.getLocalAddr());
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            String url = httpServletRequest.getRequestURI();
            String method = httpServletRequest.getMethod().toUpperCase();
            boolean shouldIntercept = this.executor.shouldIntercept(url, HttpMethod.from(method));
            if (shouldIntercept) {
                HttpRequest funcRequest = this.translate(httpServletRequest);
                HttpResponse funcResponse = this.executor.apply(url, HttpMethod.from(method), funcRequest);
                this.output((HttpServletResponse)response, funcResponse);
            } else {
                System.out.println(String.format("url: %s, not to intercept", url));
                chain.doFilter(request, response);
            }
        }
        catch (Exception ex) {
            HttpResponse httpResponse = new HttpResponse();
            httpResponse.setErrCode("InternalServerError");
            httpResponse.setErrMessage(ex.getMessage());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write(this.stringify(httpResponse));
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public WindWebFilter(RestFunctionExecutor executor) {
        this.executor = executor;
    }
}

