/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.compiler;

import com.lvonce.wind.compiler.CompilerOfGroovy;
import com.lvonce.wind.compiler.CompilerOfJava;
import com.lvonce.wind.util.ReflectUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Compiler {
    public static final Logger logger = LoggerFactory.getLogger(Compiler.class);
    public static final Map<String, Compiler> compilers = new LinkedHashMap<String, Compiler>(){
        {
            this.put(".java", new CompilerOfJava());
            this.put(".groovy", new CompilerOfGroovy());
        }
    };

    default public Logger getLogger() {
        return logger;
    }

    default public String compiledClassDir() {
        return ".tmp.compiler";
    }

    default public String getCompilerCommand() {
        return null;
    }

    public String getSourceFileSuffix();

    default public boolean supported() {
        return true;
    }

    public static Class<?>[] compileFile(File sourceFile) {
        return Compiler.compileFile(Arrays.asList(sourceFile));
    }

    public static Class<?>[] compileFile(Iterable<File> sourceFiles) {
        ArrayList classes = new ArrayList();
        for (File sourceFile : sourceFiles) {
            String fileName = sourceFile.getName();
            int i = fileName.lastIndexOf(46);
            if (i <= 0) continue;
            String suffix = fileName.substring(i);
            Compiler compiler = compilers.get(suffix);
            logger.debug("suffix -> {}, compiler map ->{}, use compiler -> {}", new Object[]{suffix, compilers, compiler});
            if (compiler == null) continue;
            classes.addAll(Arrays.asList(compiler.compile(sourceFile)));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    default public Class<?>[] compile(String fileName, String source) {
        this.clearClassDir();
        boolean success = this.execute(this.getCompilationUnits(fileName, source));
        if (success) {
            return this.getCompiledClasses();
        }
        return new Class[0];
    }

    default public Class<?>[] compile(File sourceFile) {
        logger.debug("compile({})", (Object)sourceFile);
        return this.compile(Arrays.asList(sourceFile));
    }

    default public Class<?>[] compile(Iterable<File> sourceFiles) {
        logger.debug("compile({})", sourceFiles);
        boolean success = this.execute(this.getCompilationUnits(sourceFiles));
        if (success) {
            return this.getCompiledClasses();
        }
        return new Class[0];
    }

    default public boolean execute(Iterable<?> compilationUnits) {
        return false;
    }

    default public Iterable<?> getCompilationUnits(String className, String source) {
        logger.warn("compile from string to class is not supported!");
        return null;
    }

    default public Iterable<?> getCompilationUnits(Iterable<File> sourceFiles) {
        return sourceFiles;
    }

    default public String getFileNameList(Iterable<File> fileList) {
        try {
            StringBuilder builder = new StringBuilder();
            for (File file : fileList) {
                builder.append(" ");
                builder.append(file.getCanonicalPath());
                builder.append(" ");
            }
            return builder.toString();
        }
        catch (IOException e) {
            logger.debug("getFileNameList({}) -> Error -> {}", fileList, (Object)e.getMessage());
            return "";
        }
    }

    default public Class<?>[] getCompiledClasses() {
        try {
            File[] classFiles = this.findClassFiles();
            Class[] classTypes = new Class[classFiles.length];
            for (int i = 0; i < classFiles.length; ++i) {
                File classFile = classFiles[i];
                byte[] classData = Files.readAllBytes(classFile.toPath());
                classTypes[i] = ReflectUtil.getClass(classData);
            }
            return classTypes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Class[0];
        }
    }

    default public byte[][] getCompiledClassesBytes() {
        try {
            File[] classFiles = this.findClassFiles();
            byte[][] classBytes = new byte[classFiles.length][];
            for (int i = 0; i < classFiles.length; ++i) {
                File classFile = classFiles[i];
                classBytes[i] = Files.readAllBytes(classFile.toPath());
            }
            return classBytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0][];
        }
    }

    default public void clearClassDir() {
        Path classDir = Paths.get(this.compiledClassDir(), new String[0]);
        this.clearDirs(classDir);
        if (!classDir.toFile().exists()) {
            classDir.toFile().mkdirs();
        }
    }

    default public File[] findClassFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        this.findClassFiles(Paths.get(this.compiledClassDir(), new String[0]), fileList);
        return fileList.toArray(new File[fileList.size()]);
    }

    default public void findClassFiles(Path root, ArrayList<File> fileList) {
        if (!root.toFile().exists()) {
            return;
        }
        File file = root.toFile();
        if (file.isFile()) {
            if (file.toString().endsWith(".class")) {
                fileList.add(file);
            }
        } else if (file.isDirectory()) {
            File[] childFiles;
            for (File child : childFiles = file.listFiles()) {
                this.findClassFiles(child.toPath(), fileList);
            }
        }
    }

    default public void clearDirs(Path root) {
        File file = root.toFile();
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        }
        if (file.isDirectory()) {
            File[] childFiles;
            for (File child : childFiles = file.listFiles()) {
                this.clearDirs(child.toPath());
                child.delete();
            }
        }
    }
}

