/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.compiler;

import com.lvonce.wind.compiler.Compiler;
import com.lvonce.wind.util.ReflectUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilerOfGroovy
implements Compiler {
    private static final Logger logger = LoggerFactory.getLogger(CompilerOfGroovy.class);
    private static final Method groovyParseMethod;
    private static final Object groovyClassLoader;
    private static final Class<?> groovyCodeSourceClass;

    @Override
    public boolean supported() {
        return groovyParseMethod != null;
    }

    @Override
    public String getSourceFileSuffix() {
        return ".groovy";
    }

    @Override
    public Class<?>[] compile(Iterable<File> sourceFiles) {
        ArrayList classes = new ArrayList();
        for (File file : sourceFiles) {
            classes.add(CompilerOfGroovy.findClassByGroovyFile(file));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static Class<?> findClassByGroovyFile(File file) {
        if (groovyParseMethod == null) {
            logger.warn("groovy compile is not supported, please add groovy dependency to your project!");
            return null;
        }
        try {
            Object source = ReflectUtil.createInstance(groovyCodeSourceClass, file);
            Class classType = (Class)groovyParseMethod.invoke(groovyClassLoader, source, false);
            return classType;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<?> sourceClass = null;
        Class<?> loaderClass = null;
        Object loader = null;
        Method method = null;
        try {
            sourceClass = Class.forName("groovy.lang.GroovyCodeSource");
            loaderClass = Class.forName("groovy.lang.GroovyClassLoader");
            method = loaderClass.getDeclaredMethod("parseClass", sourceClass, Boolean.TYPE);
            Constructor<?> constructor = loaderClass.getDeclaredConstructor(ClassLoader.class);
            loader = constructor.newInstance(CompilerOfGroovy.class.getClassLoader());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            loader = null;
            method = null;
            sourceClass = null;
            e.printStackTrace();
        }
        finally {
            groovyClassLoader = loader;
            groovyParseMethod = method;
            groovyCodeSourceClass = sourceClass;
        }
    }
}

