/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.compiler;

import com.lvonce.wind.compiler.Compiler;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilerOfJava
implements Compiler {
    private static final Logger logger = LoggerFactory.getLogger(CompilerOfJava.class);
    private static final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private static final DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector();
    private static final StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public String getSourceFileSuffix() {
        return ".java";
    }

    @Override
    public Iterable<?> getCompilationUnits(String className, String source) {
        JavaStringObject stringObject = new JavaStringObject(className, source);
        return Collections.singletonList(stringObject);
    }

    @Override
    public Iterable<?> getCompilationUnits(Iterable<File> sourceFiles) {
        logger.debug("getCompilationUnits({})", sourceFiles);
        return fileManager.getJavaFileObjectsFromFiles(sourceFiles);
    }

    @Override
    public boolean execute(Iterable<?> compilationList) {
        logger.debug("execute({})", compilationList);
        try {
            Iterable<?> compilationUnits = compilationList;
            Path outPath = Paths.get(this.compiledClassDir(), new String[0]);
            fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singletonList(outPath.toFile()));
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, compilationUnits);
            Boolean success = task.call();
            fileManager.close();
            if (success.booleanValue()) {
                logger.info("compile success!");
            } else {
                logger.info("compile failed!");
                for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
                    if (diagnostic == null) continue;
                    logger.debug("Code: {}%nKind: {}%nPosition: {}%nStart Position: {}%nEnd Position: {}%nSource: {}%nMessage:   {}%n", new Object[]{diagnostic.getCode(), diagnostic.getKind(), diagnostic.getPosition(), diagnostic.getStartPosition(), diagnostic.getEndPosition(), diagnostic.getSource(), diagnostic.getMessage(null)});
                }
            }
            return success;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class JavaStringObject
    extends SimpleJavaFileObject {
        private final String source;

        protected JavaStringObject(String name, String source) {
            super(URI.create("string:///" + name.replaceAll("\\.", "/") + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.source;
        }
    }
}

