/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.compiler;

import com.lvonce.wind.compiler.MemoryClassLoader;
import com.lvonce.wind.compiler.MemoryJavaFileManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class CompilerOfJavaString {
    JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    StandardJavaFileManager stdManager = this.compiler.getStandardFileManager(null, null, null);

    public Map<String, byte[]> compile(String fileName, String source) throws IOException {
        try (MemoryJavaFileManager manager = new MemoryJavaFileManager(this.stdManager);){
            JavaFileObject javaFileObject = manager.makeStringSource(fileName, source);
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, manager, null, null, null, Arrays.asList(javaFileObject));
            Boolean result = task.call();
            if (result == null || !result.booleanValue()) {
                throw new RuntimeException("Compilation failed.");
            }
            Map<String, byte[]> map = manager.getClassBytes();
            return map;
        }
    }

    public Map<String, byte[]> compile(Map<String, String> sources) throws IOException {
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, null, null);
        try (MemoryJavaFileManager manager = new MemoryJavaFileManager(fileManager);){
            ArrayList<JavaFileObject> javaFileObjectList = new ArrayList<JavaFileObject>();
            for (Map.Entry<String, String> entry : sources.entrySet()) {
                JavaFileObject javaFileObject = manager.makeStringSource(entry.getKey(), entry.getValue());
                javaFileObjectList.add(javaFileObject);
            }
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, manager, diagnostics, null, null, javaFileObjectList);
            Boolean result = task.call();
            if (result == null || !result.booleanValue()) {
                for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                    String compileErrorMsg = String.format("code: %s\nkind: %s\nposition: %s\nline: %d\nstart: %s\nend: %s\nsource: %s\nmessage: %s\n", new Object[]{diagnostic.getCode(), diagnostic.getKind(), diagnostic.getPosition(), diagnostic.getLineNumber(), diagnostic.getStartPosition(), diagnostic.getEndPosition(), diagnostic.getSource(), diagnostic.getMessage(Locale.CHINA)});
                    System.out.println(compileErrorMsg);
                }
                throw new RuntimeException("Compilation failed.");
            }
            Map<String, byte[]> map = manager.getClassBytes();
            return map;
        }
    }

    public Class<?> loadClass(String name, Map<String, byte[]> classBytes) throws ClassNotFoundException, IOException {
        try (MemoryClassLoader classLoader = new MemoryClassLoader(classBytes);){
            Class<?> clazz = classLoader.loadClass(name);
            return clazz;
        }
    }
}

