/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.factory;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Stage;
import com.lvonce.wind.RestFunction;
import com.lvonce.wind.RestRouter;
import com.lvonce.wind.SQLDataSourceManager;
import com.lvonce.wind.compiler.CompilerOfJavaString;
import com.lvonce.wind.factory.ConfigurationLoaderModule;
import com.lvonce.wind.factory.RestFunctionFactory;
import com.lvonce.wind.util.YamlUtil;
import com.lvonce.wind.watcher.DefaultDirHandler;
import com.lvonce.wind.watcher.DefaultFileHandler;
import com.lvonce.wind.watcher.DirWatcher;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestFunctionFactoryHot
implements RestFunctionFactory {
    private static final Logger log = LoggerFactory.getLogger(RestFunctionFactoryHot.class);
    private final Map<String, Supplier<RestFunction>> supplierMap = new LinkedHashMap<String, Supplier<RestFunction>>();
    private SQLDataSourceManager sqlDataSourceManager;
    private RestRouter restRouter;
    private final DirWatcher dirWatcher = new DirWatcher();
    private List<AbstractModule> modules;

    public void registerModule(Iterable<Class<?>> moduleClasses) {
        try {
            ArrayList<AbstractModule> modules = new ArrayList<AbstractModule>();
            for (Class<?> moduleClass : moduleClasses) {
                AbstractModule factoryModule = (AbstractModule)moduleClass.newInstance();
                modules.add(factoryModule);
                log.info("add module by name {}", (Object)moduleClass.getCanonicalName());
                System.out.println(String.format("add module by name %s", moduleClass.getCanonicalName()));
            }
            modules.add(new ConfigurationLoaderModule());
            this.modules = modules;
        }
        catch (Exception ex) {
            log.error(ex.getLocalizedMessage());
        }
    }

    private void registerClass(Iterable<Class<?>> classes) {
        try {
            Injector injector = Guice.createInjector((Stage)Stage.DEVELOPMENT, this.modules);
            for (Class<?> clazz : classes) {
                RestFunction func = (RestFunction)clazz.newInstance();
                log.info("func class uuid: {}", (Object)func.getClassUuid());
                Supplier<RestFunction> supplier = () -> {
                    try {
                        return (RestFunction)clazz.newInstance();
                    }
                    catch (Exception ex) {
                        return null;
                    }
                };
                String classUuid = supplier.get().getClassUuid();
                log.info("register classUuid: {}", (Object)classUuid);
                this.supplierMap.put(clazz.getCanonicalName(), supplier);
                log.info("add supplier by name: {}", (Object)clazz.getCanonicalName());
                System.out.println(String.format("add supplier by name: %s", clazz.getCanonicalName()));
            }
        }
        catch (Exception ex) {
            log.error(ex.getLocalizedMessage());
        }
    }

    boolean isSubClass(Class<?> classA, Class<?> classB) {
        try {
            classA.asSubclass(classB);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void compileSource(List<File> files) {
        try {
            if (files.isEmpty()) {
                return;
            }
            CompilerOfJavaString compiler = new CompilerOfJavaString();
            LinkedHashMap<String, String> sourceContents = new LinkedHashMap<String, String>();
            for (File file : files) {
                String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
                sourceContents.put(file.getName(), content);
                System.out.println(String.format("compile file: %s", file.getName()));
                log.info("compile file name: {}", (Object)file.getName());
                log.info("compile file {}", (Object)content);
                Map<String, byte[]> result = compiler.compile(file.getName(), content);
                try {
                    Class<?> clazz = compiler.loadClass("com.lvonce.wind.example.web.RestFunction", result);
                    RestFunction func = (RestFunction)clazz.newInstance();
                    log.info("single compile func classUuid: {}", (Object)func.getClassUuid());
                }
                catch (Exception clazz) {}
            }
            Map<String, byte[]> classMap = compiler.compile(sourceContents);
            ArrayList moduleClasses = new ArrayList();
            ArrayList functionClasses = new ArrayList();
            for (String className : classMap.keySet()) {
                Class<?> clazz = compiler.loadClass(className, classMap);
                log.info("find compiled class: {} {}", (Object)className, (Object)clazz.toString());
                System.out.println(String.format("find compiled class: %s", className));
                if (this.isSubClass(clazz, RestFunction.class)) {
                    log.info("find rest function: {}", (Object)className);
                    System.out.println(String.format("find rest function: %s", className));
                    functionClasses.add(clazz);
                }
                if (!this.isSubClass(clazz, AbstractModule.class)) continue;
                log.info("find module class: {}", (Object)className);
                System.out.println(String.format("find module class: %s", className));
                moduleClasses.add(clazz);
            }
            this.registerModule(moduleClasses);
            this.registerClass(functionClasses);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void scanDir(String dirPath) {
        File dir = new File(dirPath);
        List originFiles = (List)FileUtils.listFiles((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        this.compileSource(this.sourceFilter(originFiles));
    }

    private List<File> sourceFilter(List<File> originFiles) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            for (File file : originFiles) {
                if (file.isDirectory()) continue;
                String fileName = file.getCanonicalPath();
                if (fileName.endsWith(".java") || fileName.endsWith(".groovy")) {
                    files.add(file);
                }
                if (!fileName.endsWith(".yaml") && !fileName.endsWith(".yml")) continue;
                files.add(file);
            }
        }
        catch (Exception ex) {
            log.error(ex.getLocalizedMessage());
        }
        return files;
    }

    private boolean configFilter(File file) {
        try {
            String fileName = file.getCanonicalPath();
            return fileName.endsWith(".yaml") || fileName.endsWith(".yml");
        }
        catch (Exception ex) {
            log.error(ex.getLocalizedMessage());
            return false;
        }
    }

    public void watchDirToCompile(String watcherName, String dir) {
        try {
            DirWatcher.DirWatchItem watchItem = new DirWatcher.DirWatchItem(FileSystems.getDefault().getPath(dir, new String[0]), this::sourceFilter, this::compileSource, this::compileSource, new DefaultDirHandler());
            this.dirWatcher.watchDir(watcherName, watchItem);
        }
        catch (Exception ex) {
            log.error(ex.getLocalizedMessage());
        }
    }

    private void loadConfig(File configFile) throws Exception {
        String content = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
        RestRouter.RouterConfig config = YamlUtil.fromYaml(content, RestRouter.RouterConfig.class).orElse(null);
        if (config != null) {
            if (this.restRouter == null) {
                this.restRouter = new RestRouter(config);
            } else {
                this.restRouter.update(config);
            }
        }
    }

    public void watchFileToLoad(String watcherName, String fileName) {
        try {
            DirWatcher.FileWatchItem watchItem = new DirWatcher.FileWatchItem(FileSystems.getDefault().getPath(fileName, new String[0]), this::configFilter, this::loadConfig, this::loadConfig, new DefaultFileHandler());
            this.dirWatcher.watchFile(watcherName, watchItem);
        }
        catch (Exception ex) {
            log.error(ex.getLocalizedMessage());
        }
    }

    @Override
    public void register(String name, Supplier<RestFunction> supplier) {
        this.supplierMap.put(name, supplier);
    }

    @Override
    public RestFunction getFunction(String name) {
        Supplier<RestFunction> supplier = this.supplierMap.get(name);
        if (supplier != null) {
            return supplier.get();
        }
        return null;
    }
}

