/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.function;

import com.lvonce.wind.function.ExtractorDef;
import com.lvonce.wind.function.ExtractorResult;
import com.lvonce.wind.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Extractor {
    public static boolean isSubClass(Class<?> classA, Class<?> classB) {
        try {
            classA.asSubclass(classB);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Object convert(String value, Class<?> clazz) {
        return JsonUtil.fromJson(value, clazz).orElse(null);
    }

    public static Object convert(String[] value, Class<?> clazz) {
        if (Extractor.isSubClass(clazz, String.class)) {
            return String.join((CharSequence)",", value);
        }
        String content = JsonUtil.toJson(value).orElse("");
        return JsonUtil.fromJson(content, clazz).orElse(null);
    }

    public static ExtractorResult extract(HttpServletRequest httpServletRequest, ExtractorDef extractorDef) throws IOException {
        ExtractorResult result = ExtractorResult.make(extractorDef);
        Map<String, ExtractorDef.ExtractItem> headerExtractMap = extractorDef.headerExtractItems;
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            ExtractorDef.ExtractItem extractItem = headerExtractMap.get(headerName);
            if (extractItem == null) continue;
            String header = httpServletRequest.getHeader(headerName);
            Object value = Extractor.convert(header, extractItem.valueType);
            result.setValue(extractItem.idx, value);
        }
        Map parameterMap = httpServletRequest.getParameterMap();
        Map<String, ExtractorDef.ExtractItem> paramExtractMap = extractorDef.paramExtractItems;
        for (Map.Entry<String, ExtractorDef.ExtractItem> entry : paramExtractMap.entrySet()) {
            ExtractorDef.ExtractItem item = entry.getValue();
            String[] content = (String[])parameterMap.get(item.name);
            Object value = Extractor.convert(content, item.valueType);
            result.setValue(item.idx, value);
        }
        Map<String, Object> bodyMap = JsonUtil.readJsonToMap((InputStream)httpServletRequest.getInputStream());
        Map<String, ExtractorDef.ExtractItem> bodyExtractMap = extractorDef.bodyExtractItems;
        for (Map.Entry<String, ExtractorDef.ExtractItem> entry : bodyExtractMap.entrySet()) {
            ExtractorDef.ExtractItem item = entry.getValue();
            Object value = bodyMap.get(item.name);
            result.setValue(item.idx, value);
        }
        return result;
    }
}

