/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.function;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExtractorDef {
    List<ExtractItem> extractItems = new ArrayList<ExtractItem>();
    Map<String, ExtractItem> headerExtractItems = new LinkedHashMap<String, ExtractItem>();
    Map<String, ExtractItem> pathExtractItems = new LinkedHashMap<String, ExtractItem>();
    Map<String, ExtractItem> paramExtractItems = new LinkedHashMap<String, ExtractItem>();
    Map<String, ExtractItem> bodyExtractItems = new LinkedHashMap<String, ExtractItem>();
    Map<String, ExtractItem> cookieExtractItems = new LinkedHashMap<String, ExtractItem>();

    public void addExtractItem(ExtractSource source, String name, Class<?> clazz) {
        int idx = this.extractItems.size();
        ExtractItem item = new ExtractItem(idx, source, name, clazz);
        this.extractItems.add(item);
        switch (source) {
            case BODY: {
                this.bodyExtractItems.put(item.name, item);
                break;
            }
            case PATH: {
                this.pathExtractItems.put(item.name, item);
                break;
            }
            case PARAM: {
                this.paramExtractItems.put(item.name, item);
                break;
            }
            case HEADER: {
                this.headerExtractItems.put(item.name, item);
                break;
            }
            case COOKIE: {
                this.cookieExtractItems.put(item.name, item);
            }
        }
    }

    public List<ExtractItem> getExtractItems() {
        return this.extractItems;
    }

    public Map<String, ExtractItem> getHeaderExtractItems() {
        return this.headerExtractItems;
    }

    public Map<String, ExtractItem> getPathExtractItems() {
        return this.pathExtractItems;
    }

    public Map<String, ExtractItem> getParamExtractItems() {
        return this.paramExtractItems;
    }

    public Map<String, ExtractItem> getBodyExtractItems() {
        return this.bodyExtractItems;
    }

    public Map<String, ExtractItem> getCookieExtractItems() {
        return this.cookieExtractItems;
    }

    public static class ExtractItem {
        int idx;
        ExtractSource source;
        String name;
        Class<?> valueType;

        public int getIdx() {
            return this.idx;
        }

        public ExtractSource getSource() {
            return this.source;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public void setIdx(int idx) {
            this.idx = idx;
        }

        public void setSource(ExtractSource source) {
            this.source = source;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValueType(Class<?> valueType) {
            this.valueType = valueType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtractItem)) {
                return false;
            }
            ExtractItem other = (ExtractItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIdx() != other.getIdx()) {
                return false;
            }
            ExtractSource this$source = this.getSource();
            ExtractSource other$source = other.getSource();
            if (this$source == null ? other$source != null : !((Object)((Object)this$source)).equals((Object)other$source)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<?> this$valueType = this.getValueType();
            Class<?> other$valueType = other.getValueType();
            return !(this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExtractItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIdx();
            ExtractSource $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : ((Object)((Object)$source)).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<?> $valueType = this.getValueType();
            result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
            return result;
        }

        public String toString() {
            return "ExtractorDef.ExtractItem(idx=" + this.getIdx() + ", source=" + (Object)((Object)this.getSource()) + ", name=" + this.getName() + ", valueType=" + this.getValueType() + ")";
        }

        public ExtractItem(int idx, ExtractSource source, String name, Class<?> valueType) {
            this.idx = idx;
            this.source = source;
            this.name = name;
            this.valueType = valueType;
        }
    }

    public static enum ExtractSource {
        HEADER,
        PATH,
        PARAM,
        BODY,
        COOKIE;

    }
}

