/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lvonce.wind.util.JsonUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Map;

public class HttpRequestBody {
    private static ObjectMapper mapper = new ObjectMapper();
    private InputStream input;

    public Map<String, Object> asMap() {
        return JsonUtil.readJsonToMap(this.input);
    }

    public String asText() {
        try {
            return (String)mapper.readValue(this.input, String.class);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public Short asShort() {
        try {
            return (Short)mapper.readValue(this.input, Short.class);
        }
        catch (Exception ex) {
            return (short)0;
        }
    }

    public Integer asInt() {
        try {
            return (Integer)mapper.readValue(this.input, Integer.class);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public Long asLong() {
        try {
            return (Long)mapper.readValue(this.input, Long.class);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public Float asFloat() {
        try {
            return (Float)mapper.readValue(this.input, Float.class);
        }
        catch (Exception ex) {
            return Float.valueOf(0.0f);
        }
    }

    public Double asDouble() {
        try {
            return (Double)mapper.readValue(this.input, Double.class);
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    public BigDecimal asBigDecimal() {
        try {
            return (BigDecimal)mapper.readValue(this.input, BigDecimal.class);
        }
        catch (Exception ex) {
            return BigDecimal.ZERO;
        }
    }

    public HttpRequestBody(InputStream input) {
        this.input = input;
    }
}

