/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.processor;

import com.lvonce.wind.ConverterBuilder;
import com.lvonce.wind.ValidatorBuilder;
import com.lvonce.wind.processor.AttrProcessor;
import com.lvonce.wind.processor.Processor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AttrMapProcessor
implements Processor {
    Map<String, Object> attrMap;
    Map<String, AttrProcessorArg> processorArgMap = new LinkedHashMap<String, AttrProcessorArg>();

    public AttrMapProcessor(Map<String, Object> attrMap, List<AttrProcessorArg> argList) {
        this.attrMap = attrMap;
        for (AttrProcessorArg arg : argList) {
            this.processorArgMap.put(arg.oldName, arg);
        }
    }

    @Override
    public Processor.ProcessResult process() {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.attrMap.entrySet()) {
            String attrName = entry.getKey();
            Object val = entry.getValue();
            AttrProcessorArg processorArg = this.processorArgMap.get(attrName);
            AttrProcessor processor = new AttrProcessor(val, processorArg.converterArg, processorArg.validatorArg);
            Processor.ProcessResult processResult = processor.process();
            if (!processResult.isSuccess()) {
                return Processor.ProcessResult.ofFailure(processResult.errMsg);
            }
            resultMap.put(processorArg.newName, processResult.val);
        }
        return Processor.ProcessResult.ofSuccess(resultMap);
    }

    public static class AttrProcessorArg {
        String oldName;
        String newName;
        ConverterBuilder.TypeConverterBuildArg converterArg;
        ValidatorBuilder.ValidatorBuildArg validatorArg;

        public AttrProcessorArg(String oldName, String newName, ConverterBuilder.TypeConverterBuildArg converterArg, ValidatorBuilder.ValidatorBuildArg validatorArg) {
            this.oldName = oldName;
            this.newName = newName;
            this.converterArg = converterArg;
            this.validatorArg = validatorArg;
        }

        public AttrProcessorArg(String oldName, ConverterBuilder.TypeConverterBuildArg converterArg, ValidatorBuilder.ValidatorBuildArg validatorArg) {
            this.oldName = oldName;
            this.newName = oldName;
            this.converterArg = converterArg;
            this.validatorArg = validatorArg;
        }

        public String getOldName() {
            return this.oldName;
        }

        public String getNewName() {
            return this.newName;
        }

        public ConverterBuilder.TypeConverterBuildArg getConverterArg() {
            return this.converterArg;
        }

        public ValidatorBuilder.ValidatorBuildArg getValidatorArg() {
            return this.validatorArg;
        }

        public void setOldName(String oldName) {
            this.oldName = oldName;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public void setConverterArg(ConverterBuilder.TypeConverterBuildArg converterArg) {
            this.converterArg = converterArg;
        }

        public void setValidatorArg(ValidatorBuilder.ValidatorBuildArg validatorArg) {
            this.validatorArg = validatorArg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttrProcessorArg)) {
                return false;
            }
            AttrProcessorArg other = (AttrProcessorArg)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$oldName = this.getOldName();
            String other$oldName = other.getOldName();
            if (this$oldName == null ? other$oldName != null : !this$oldName.equals(other$oldName)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            if (this$newName == null ? other$newName != null : !this$newName.equals(other$newName)) {
                return false;
            }
            ConverterBuilder.TypeConverterBuildArg this$converterArg = this.getConverterArg();
            ConverterBuilder.TypeConverterBuildArg other$converterArg = other.getConverterArg();
            if (this$converterArg == null ? other$converterArg != null : !((Object)this$converterArg).equals(other$converterArg)) {
                return false;
            }
            ValidatorBuilder.ValidatorBuildArg this$validatorArg = this.getValidatorArg();
            ValidatorBuilder.ValidatorBuildArg other$validatorArg = other.getValidatorArg();
            return !(this$validatorArg == null ? other$validatorArg != null : !((Object)this$validatorArg).equals(other$validatorArg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AttrProcessorArg;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $oldName = this.getOldName();
            result = result * 59 + ($oldName == null ? 43 : $oldName.hashCode());
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            ConverterBuilder.TypeConverterBuildArg $converterArg = this.getConverterArg();
            result = result * 59 + ($converterArg == null ? 43 : ((Object)$converterArg).hashCode());
            ValidatorBuilder.ValidatorBuildArg $validatorArg = this.getValidatorArg();
            result = result * 59 + ($validatorArg == null ? 43 : ((Object)$validatorArg).hashCode());
            return result;
        }

        public String toString() {
            return "AttrMapProcessor.AttrProcessorArg(oldName=" + this.getOldName() + ", newName=" + this.getNewName() + ", converterArg=" + this.getConverterArg() + ", validatorArg=" + this.getValidatorArg() + ")";
        }
    }
}

