/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.processor;

import com.lvonce.wind.ConverterBuilder;
import com.lvonce.wind.ValidatorBuilder;
import com.lvonce.wind.converter.Converter;
import com.lvonce.wind.processor.Processor;
import com.lvonce.wind.validator.Validator;

public class AttrProcessor
implements Processor {
    private final Converter converter;
    private ValidatorBuilder.ValidatorBuildArg validatorArg;
    private final Object attr;

    public AttrProcessor(Object attr, ConverterBuilder.TypeConverterBuildArg converterArg, ValidatorBuilder.ValidatorBuildArg validatorArg) {
        this.attr = attr;
        this.converter = ConverterBuilder.genTypeConverter(converterArg);
        this.validatorArg = validatorArg;
    }

    @Override
    public Processor.ProcessResult process() {
        Object converted = this.attr;
        if (this.converter != null) {
            converted = this.converter.converter(this.attr);
        }
        if (this.validatorArg != null) {
            Validator validator = ValidatorBuilder.genValidator(this.validatorArg);
            validator.accept(converted);
            Validator.ValidateResult result = Validator.ValidateResult.ofSuccess();
            if (validator != null) {
                result = validator.validate();
            }
            if (result.isSuccess()) {
                return Processor.ProcessResult.ofSuccess(converted);
            }
            return Processor.ProcessResult.ofFailure(result.getErrMsg());
        }
        return Processor.ProcessResult.ofSuccess(converted);
    }
}

