/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.processor;

public interface Processor {
    public ProcessResult process();

    public static class ProcessResult {
        Object val;
        String errMsg;

        private ProcessResult(Object obj, String errMsg) {
            this.val = obj;
            this.errMsg = "Process Error: " + errMsg;
        }

        public static ProcessResult ofSuccess(Object val) {
            return new ProcessResult(val, null);
        }

        public static ProcessResult ofFailure(String errMsg) {
            return new ProcessResult(null, errMsg);
        }

        public static ProcessResult ofResult(Object obj, String errMsg) {
            if (obj != null) {
                return ProcessResult.ofSuccess(obj);
            }
            return ProcessResult.ofFailure(errMsg);
        }

        public boolean isSuccess() {
            return this.val != null;
        }

        public Object getVal() {
            return this.val;
        }

        public String getErrMsg() {
            return this.errMsg;
        }
    }
}

