/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.sql;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.managed.ManagedTransaction;

public class MybatisExecutor {
    Executor executor;
    Configuration config;
    XMLLanguageDriver languageDriver;

    public static MybatisExecutor build(Connection connection) {
        MybatisExecutor executor = new MybatisExecutor();
        Configuration config = new Configuration();
        ManagedTransaction trx = new ManagedTransaction(connection, false);
        executor.config = config;
        executor.languageDriver = new XMLLanguageDriver();
        executor.executor = config.newExecutor((Transaction)trx);
        return executor;
    }

    public List<Map<String, Object>> query(String xmlSql, Map<String, Object> queryParams) throws Exception {
        String id = UUID.nameUUIDFromBytes(xmlSql.getBytes()).toString();
        String xml = "<script>" + xmlSql + "</script>";
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.config, xml, null);
        MappedStatement.Builder builder = new MappedStatement.Builder(this.config, id, sqlSource, SqlCommandType.SELECT);
        ResultMap resultMap = new ResultMap.Builder(this.config, id, Map.class, new ArrayList()).build();
        builder.resultMaps(Collections.singletonList(resultMap));
        MappedStatement statement = builder.build();
        List results = this.executor.query(statement, queryParams, RowBounds.DEFAULT, null);
        return results;
    }

    private List<Map<String, Object>> query(String id, String xmlSql, Map<String, Object> queryParams) throws Exception {
        String xml = "<script>" + xmlSql + "</script>";
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.config, xml, null);
        MappedStatement.Builder builder = new MappedStatement.Builder(this.config, id, sqlSource, SqlCommandType.SELECT);
        ResultMap resultMap = new ResultMap.Builder(this.config, id, Map.class, new ArrayList()).build();
        builder.resultMaps(Collections.singletonList(resultMap));
        MappedStatement statement = builder.build();
        List results = this.executor.query(statement, queryParams, RowBounds.DEFAULT, null);
        return results;
    }
}

