/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.sql;

import com.lvonce.wind.sql.IsolationLevel;
import com.lvonce.wind.sql.MybatisExecutor;
import com.lvonce.wind.sql.TransactionHandler;
import com.lvonce.wind.sql.TransactionState;
import com.lvonce.wind.sql.handler.TransactionHandlerImpl;
import com.lvonce.wind.sql.handler.TransactionHandlerNoneImpl;
import com.lvonce.wind.sql.statment.NamedParameterStatement;
import com.lvonce.wind.sql.statment.SqlStatement;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    private static final Logger log = LoggerFactory.getLogger(Transaction.class);
    private final Connection connection;
    private final IsolationLevel level;
    private final TransactionState state;
    private final MybatisExecutor executor;

    public Transaction(Connection connection, IsolationLevel level, TransactionState state) {
        this.connection = connection;
        this.level = level;
        this.state = state;
        this.executor = MybatisExecutor.build(connection);
    }

    public TransactionHandler trx() {
        if (this.level.equals((Object)IsolationLevel.NONE)) {
            return new TransactionHandlerNoneImpl(this.connection, this.state);
        }
        return new TransactionHandlerImpl(this.connection, this.level, this.state);
    }

    public List<Map<String, Object>> mybatisSql(String xmlSql, Map<String, Object> queryParams) {
        try {
            return this.executor.query(xmlSql, queryParams);
        }
        catch (Exception ex) {
            log.info("SqlStatement prepare({}) error: {}", (Object)xmlSql, (Object)ex);
            return null;
        }
    }

    public List<Map<String, Object>> namedSql(String namedSql, Map<String, Object> queryParams) {
        try {
            NamedParameterStatement namedParameterStatement = new NamedParameterStatement(this.connection, namedSql);
            this.state.registerStatement(namedParameterStatement);
            SqlStatement sqlStatement = new SqlStatement(this.state, namedParameterStatement);
            return sqlStatement.query(queryParams);
        }
        catch (Exception ex) {
            log.info("SqlStatement prepare({}) error: {}", (Object)namedSql, (Object)ex);
            return null;
        }
    }

    public SqlStatement sql(String sql) {
        try {
            NamedParameterStatement namedParameterStatement = new NamedParameterStatement(this.connection, sql);
            this.state.registerStatement(namedParameterStatement);
            return new SqlStatement(this.state, namedParameterStatement);
        }
        catch (Exception ex) {
            log.info("SqlStatement prepare({}) error: {}", (Object)sql, (Object)ex);
            return null;
        }
    }
}

