/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.sql.handler;

import com.lvonce.wind.sql.IsolationLevel;
import com.lvonce.wind.sql.Transaction;
import com.lvonce.wind.sql.TransactionFunc;
import com.lvonce.wind.sql.TransactionHandler;
import com.lvonce.wind.sql.TransactionResult;
import com.lvonce.wind.sql.TransactionState;
import com.lvonce.wind.sql.state.TransactionStateImpl;
import java.sql.Connection;
import java.sql.Savepoint;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandlerImpl
implements TransactionHandler {
    private static final Logger log = LoggerFactory.getLogger(TransactionHandlerImpl.class);
    private final Connection connection;
    private final IsolationLevel isolationLevel;
    private final TransactionState transactionState;
    private final boolean isNestedTransaction;
    private Savepoint savepoint;

    public TransactionHandlerImpl(Connection connection, IsolationLevel isolationLevel) {
        this.connection = connection;
        this.isNestedTransaction = false;
        this.transactionState = new TransactionStateImpl(connection);
        this.savepoint = null;
        this.isolationLevel = isolationLevel;
    }

    public TransactionHandlerImpl(Connection connection, IsolationLevel isolationLevel, TransactionState state) {
        this.connection = connection;
        this.isNestedTransaction = true;
        this.transactionState = state;
        this.savepoint = null;
        this.isolationLevel = isolationLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionResult apply(TransactionFunc func) {
        try {
            if (!this.isNestedTransaction) {
                this.connection.setTransactionIsolation(this.isolationLevel.getLevel());
                this.connection.setAutoCommit(false);
            } else {
                String savePointName = UUID.randomUUID().toString();
                this.savepoint = this.connection.setSavepoint(savePointName);
            }
            TransactionResult result = func.execute(new Transaction(this.connection, this.isolationLevel, this.transactionState));
            this.transactionState.commit();
            TransactionResult transactionResult = result;
            return transactionResult;
        }
        catch (Exception ex) {
            if (this.savepoint == null) {
                this.transactionState.rollback();
            } else {
                this.transactionState.rollback(this.savepoint);
            }
            TransactionResult transactionResult = new TransactionResult(false, 0, ex.getLocalizedMessage(), null);
            return transactionResult;
        }
        finally {
            try {
                if (this.connection != null && !this.connection.isClosed() && !this.isNestedTransaction) {
                    this.connection.setAutoCommit(true);
                }
            }
            catch (Exception ex) {
                log.debug("Transaction setAutoCommit(true) error:", (Throwable)ex);
            }
            this.transactionState.close();
        }
    }
}

