/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.sql.state;

import com.lvonce.wind.sql.TransactionState;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionStateImpl
implements TransactionState {
    private static final Logger log = LoggerFactory.getLogger(TransactionStateImpl.class);
    private final Connection connection;
    private final List<Statement> statements = new ArrayList<Statement>();
    private final List<ResultSet> resultSets = new ArrayList<ResultSet>();

    public TransactionStateImpl(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void registerStatement(Statement statement) {
        this.statements.add(0, statement);
    }

    @Override
    public void registerResult(ResultSet resultSet) {
        this.resultSets.add(0, resultSet);
    }

    @Override
    public void commit() throws SQLException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.commit();
            }
        }
        catch (SQLException ex) {
            log.debug("TRANSACTION_COMMIT_ERROR, Failed to commit transaction transaction:", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void rollback() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.rollback();
            }
        }
        catch (SQLException ex) {
            log.debug("TRANSACTION_ROLLBACK_ERROR, Failed to rollback transaction: ", (Throwable)ex);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.rollback(savepoint);
            }
        }
        catch (SQLException ex) {
            log.debug("TRANSACTION_ROLLBACK_ERROR, Failed to rollback transaction: ", (Throwable)ex);
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && this.connection.isClosed()) {
                log.debug("CLOSING_CLOSED_CONNECTION, Tried to close already closed connection! Check for some unwanted close() in your code.");
                return;
            }
            for (ResultSet resultSet : this.resultSets) {
                resultSet.close();
            }
            for (Statement statement : this.statements) {
                statement.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException ex) {
            log.debug("TRANSACTION_CLOSE_ERROR, Failed to close transaction.", (Throwable)ex);
        }
    }
}

