/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.sql.statment;

import com.lvonce.wind.sql.statment.PreparedStatementWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NamedParameterStatement
extends PreparedStatementWrapper {
    private static final HashMap<String, Map<String, List<Integer>>> nameIndexCache = new HashMap();
    private static final HashMap<String, String> parsedSqlCache = new HashMap();
    private final String parsedSql;
    private final Map<String, List<Integer>> nameIndexMap;

    public NamedParameterStatement(Connection conn, String sql) throws SQLException {
        if (nameIndexCache.containsKey(sql)) {
            this.nameIndexMap = nameIndexCache.get(sql);
            this.parsedSql = parsedSqlCache.get(sql);
        } else {
            this.nameIndexMap = new HashMap<String, List<Integer>>();
            this.parsedSql = NamedParameterStatement.parseNamedSql(sql, this.nameIndexMap);
            nameIndexCache.put(sql, this.nameIndexMap);
            parsedSqlCache.put(sql, this.parsedSql);
        }
        this.ps = conn.prepareStatement(this.parsedSql);
    }

    public Map<String, List<Integer>> getNameIndexMap() {
        return this.nameIndexMap;
    }

    private List<Integer> getIndexes(String name) {
        List<Integer> indexes = this.nameIndexMap.get(name);
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter not found: " + name);
        }
        return indexes;
    }

    private static String parseNamedSql(String sql, Map<String, List<Integer>> nameIndexMap) {
        int length = sql.length();
        StringBuffer parsedSql = new StringBuffer(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int index = 1;
        for (int i = 0; i < length; ++i) {
            int c = sql.charAt(i);
            if (inSingleQuote) {
                if (c == 39) {
                    inSingleQuote = false;
                }
            } else if (inDoubleQuote) {
                if (c == 34) {
                    inDoubleQuote = false;
                }
            } else if (c == 39) {
                inSingleQuote = true;
            } else if (c == 34) {
                inDoubleQuote = true;
            } else if (c == 58 && i + 1 < length && Character.isJavaIdentifierStart(sql.charAt(i + 1))) {
                int j;
                for (j = i + 2; j < length && Character.isJavaIdentifierPart(sql.charAt(j)); ++j) {
                }
                String name = sql.substring(i + 1, j);
                c = 63;
                i += name.length();
                List<Integer> indexList = nameIndexMap.get(name);
                if (indexList == null) {
                    indexList = new LinkedList<Integer>();
                    nameIndexMap.put(name, indexList);
                }
                indexList.add(index);
                ++index;
            }
            parsedSql.append((char)c);
        }
        return parsedSql.toString();
    }

    public void setArray(String name, Array value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setArray(index, value);
        }
    }

    public void setAsciiStream(String name, InputStream value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setAsciiStream(index, value);
        }
    }

    public void setAsciiStream(String name, InputStream value, int length) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setAsciiStream((int)index, value, length);
        }
    }

    public void setBigDecimal(String name, BigDecimal value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setBigDecimal(index, value);
        }
    }

    public void setBinaryStream(String name, InputStream value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setBinaryStream(index, value);
        }
    }

    public void setBinaryStream(String name, InputStream value, int length) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setBinaryStream((int)index, value, length);
        }
    }

    public void setBinaryStream(String name, InputStream value, long length) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setBinaryStream((int)index, value, length);
        }
    }

    public void setBlob(String name, Blob value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setBlob((int)index, value);
        }
    }

    public void setBlob(String name, InputStream value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setBlob((int)index, value);
        }
    }

    public void setBlob(String name, InputStream value, long length) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setBlob(index, value, length);
        }
    }

    public void setBoolean(String name, boolean value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setBoolean(index, value);
        }
    }

    public void setByte(String name, byte value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setByte(index, value);
        }
    }

    public void setBytes(String name, byte[] value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setBytes(index, value);
        }
    }

    public void setCharacterStream(String name, Reader value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setCharacterStream(index, value);
        }
    }

    public void setCharacterStream(String name, Reader value, int length) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setCharacterStream((int)index, value, length);
        }
    }

    public void setCharacterStream(String name, Reader value, long length) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setCharacterStream((int)index, value, length);
        }
    }

    public void setClob(String name, Clob value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setClob((int)index, value);
        }
    }

    public void setClob(String name, Reader value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setClob((int)index, value);
        }
    }

    public void setClob(String name, Reader value, long length) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setClob(index, value, length);
        }
    }

    public void setDate(String name, Date value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setDate(index, value);
        }
    }

    public void setDate(String name, Date value, Calendar cal) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setDate(index, value, cal);
        }
    }

    public void setDouble(String name, double value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setDouble(index, value);
        }
    }

    public void setFloat(String name, float value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setFloat(index, value);
        }
    }

    public void setInt(String name, int value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setInt(index, value);
        }
    }

    public void setLong(String name, long value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setLong(index, value);
        }
    }

    public void setNCharacterStream(String name, Reader value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setNCharacterStream(index, value);
        }
    }

    public void setNCharacterStream(String name, Reader value, long length) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setNCharacterStream(index, value, length);
        }
    }

    public void setNClob(String name, NClob value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setNClob((int)index, value);
        }
    }

    public void setNClob(String name, Reader value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setNClob((int)index, value);
        }
    }

    public void setNClob(String name, Reader value, long length) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setNClob(index, value, length);
        }
    }

    public void setNString(String name, String value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setNString(index, value);
        }
    }

    public void setNull(String name, int sqlType) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setNull(index, sqlType);
        }
    }

    public void setObject(String name, Object value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setObject(index, value);
        }
    }

    public void setObject(String name, Object value, int targetSqlType) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setObject((int)index, value, targetSqlType);
        }
    }

    public void setObject(String name, Object value, int targetSqlType, int scaleOrLength) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setObject((int)index, value, targetSqlType, scaleOrLength);
        }
    }

    public void setRef(String name, Ref value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setRef(index, value);
        }
    }

    public void setRowId(String name, RowId value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setRowId(index, value);
        }
    }

    public void setShort(String name, short value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setShort(index, value);
        }
    }

    public void setSQLXML(String name, SQLXML value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setSQLXML(index, value);
        }
    }

    public void setString(String name, String value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setString(index, value);
        }
    }

    public void setTime(String name, Time value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setTime(index, value);
        }
    }

    public void setTime(String name, Time value, Calendar cal) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setTime(index, value, cal);
        }
    }

    public void setTimestamp(String name, Timestamp value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setTimestamp(index, value);
        }
    }

    public void setTimestamp(String name, Timestamp value, Calendar cal) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setTimestamp(index, value, cal);
        }
    }

    public void setUnicodeStream(String name, InputStream value, int length) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setUnicodeStream(index, value, length);
        }
    }

    public void setURL(String name, URL value) throws SQLException {
        for (Integer index : this.getIndexes(name)) {
            this.ps.setURL(index, value);
        }
    }
}

