/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.sql.statment;

import com.lvonce.wind.sql.TransactionState;
import com.lvonce.wind.sql.statment.NamedParameterStatement;
import com.lvonce.wind.util.ResultSetUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class SqlStatement {
    private TransactionState state;
    private NamedParameterStatement namedStatement;

    private boolean bindValue(Map<String, Object> values) {
        try {
            Map<String, List<Integer>> nameMap = this.namedStatement.getNameIndexMap();
            for (String paramName : nameMap.keySet()) {
                this.namedStatement.setString(paramName, values.get(paramName).toString());
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean bindValue(String name, Object value) {
        try {
            Map<String, List<Integer>> nameMap = this.namedStatement.getNameIndexMap();
            if (!nameMap.containsKey(name)) {
                return false;
            }
            this.namedStatement.setString(name, value.toString());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List<Map<String, Object>> query(Map<String, Object> values) throws SQLException {
        boolean bindSuccess = this.bindValue(values);
        if (!bindSuccess) {
            return null;
        }
        ResultSet result = this.namedStatement.executeQuery();
        this.state.registerResult(result);
        return ResultSetUtil.toArrayOfMap(result);
    }

    public int update(Map<String, Object> values) throws SQLException {
        boolean bindSuccess = this.bindValue(values);
        if (!bindSuccess) {
            return 0;
        }
        return this.namedStatement.executeUpdate();
    }

    public List<Map<String, Object>> query(String name, Object value) throws SQLException {
        boolean bindSuccess = this.bindValue(name, value);
        if (!bindSuccess) {
            return null;
        }
        ResultSet result = this.namedStatement.executeQuery();
        this.state.registerResult(result);
        return ResultSetUtil.toArrayOfMap(result);
    }

    public int update(String name, Object value) throws SQLException {
        boolean bindSuccess = this.bindValue(name, value);
        if (!bindSuccess) {
            return 0;
        }
        return this.namedStatement.executeUpdate();
    }

    public void close() throws SQLException {
        this.namedStatement.close();
    }

    public SqlStatement() {
    }

    public SqlStatement(TransactionState state, NamedParameterStatement namedStatement) {
        this.state = state;
        this.namedStatement = namedStatement;
    }
}

