/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.task.context;

import com.lvonce.wind.task.enums.FlowState;
import com.lvonce.wind.task.enums.TaskState;
import com.lvonce.wind.task.event.TaskRoutedEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class FlowContext {
    private final String uuid;
    private final ArrayList<TaskRoutedEvent<?>> path = new ArrayList();
    private final Map<Integer, TaskRoutedEvent<?>> resultMap = new LinkedHashMap();
    private FlowState flowState = FlowState.EMPTY;

    public FlowContext() {
        this.uuid = UUID.randomUUID().toString();
    }

    public FlowContext(String uuid) {
        this.uuid = uuid;
    }

    public TaskRoutedEvent<?> peekEvent() {
        int last = this.path.size() - 1;
        if (last < 0) {
            return null;
        }
        return this.path.get(last);
    }

    public <T> T getResultBySeq(int taskSeq) {
        return (T)this.resultMap.get(taskSeq).getTaskevent().getData();
    }

    public void pushEvent(TaskRoutedEvent<?> event) {
        TaskState taskState = event.getTaskevent().getState();
        this.flowState = FlowState.from(taskState);
        this.path.add(event);
    }

    public void pushResult(TaskRoutedEvent<?> event) {
        this.resultMap.put(event.getRouteevent().getCurrTaskSeq(), event);
        this.pushEvent(event);
    }

    public void finish() {
        if (this.flowState.equals((Object)FlowState.PENDING)) {
            this.flowState = FlowState.SUCCESS;
        }
        if (this.flowState.equals((Object)FlowState.CANCELLING)) {
            this.flowState = FlowState.FAIL;
        }
    }

    public TaskRoutedEvent<?> popEvent() {
        TaskRoutedEvent<?> result = null;
        int last = this.path.size() - 1;
        if (last >= 0) {
            result = this.path.remove(last);
        }
        return result;
    }

    public String getUuid() {
        return this.uuid;
    }

    public ArrayList<TaskRoutedEvent<?>> getPath() {
        return this.path;
    }

    public Map<Integer, TaskRoutedEvent<?>> getResultMap() {
        return this.resultMap;
    }

    public FlowState getFlowState() {
        return this.flowState;
    }

    public void setFlowState(FlowState flowState) {
        this.flowState = flowState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowContext)) {
            return false;
        }
        FlowContext other = (FlowContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        ArrayList<TaskRoutedEvent<?>> this$path = this.getPath();
        ArrayList<TaskRoutedEvent<?>> other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        Map<Integer, TaskRoutedEvent<?>> this$resultMap = this.getResultMap();
        Map<Integer, TaskRoutedEvent<?>> other$resultMap = other.getResultMap();
        if (this$resultMap == null ? other$resultMap != null : !((Object)this$resultMap).equals(other$resultMap)) {
            return false;
        }
        FlowState this$flowState = this.getFlowState();
        FlowState other$flowState = other.getFlowState();
        return !(this$flowState == null ? other$flowState != null : !((Object)((Object)this$flowState)).equals((Object)other$flowState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        ArrayList<TaskRoutedEvent<?>> $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        Map<Integer, TaskRoutedEvent<?>> $resultMap = this.getResultMap();
        result = result * 59 + ($resultMap == null ? 43 : ((Object)$resultMap).hashCode());
        FlowState $flowState = this.getFlowState();
        result = result * 59 + ($flowState == null ? 43 : ((Object)((Object)$flowState)).hashCode());
        return result;
    }

    public String toString() {
        return "FlowContext(uuid=" + this.getUuid() + ", path=" + this.getPath() + ", resultMap=" + this.getResultMap() + ", flowState=" + (Object)((Object)this.getFlowState()) + ")";
    }
}

