/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.task.context;

import com.lvonce.wind.task.enums.BranchNode;
import com.lvonce.wind.task.enums.TaskSeq;
import com.lvonce.wind.task.enums.TaskState;
import com.lvonce.wind.task.event.RouteEvent;
import com.lvonce.wind.task.event.TaskEvent;
import com.lvonce.wind.task.event.TaskRoutedEvent;
import com.lvonce.wind.task.route.ActionRoute;
import com.lvonce.wind.task.route.BranchRoute;
import com.lvonce.wind.task.route.Route;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class GraphContext {
    private String uuid = UUID.randomUUID().toString();
    private Integer start = null;
    private final Set<Integer> ends = new LinkedHashSet<Integer>();
    private final Set<Integer> asyncTasks = new LinkedHashSet<Integer>();
    private final Map<Integer, Integer> retryCountLimit = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Integer> nextTasks = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, String> taskUuidMap = new LinkedHashMap<Integer, String>();
    private final Map<Integer, Route> routeMap = new LinkedHashMap<Integer, Route>();
    private String bpmnDefinition = null;

    public void buildByDefinition(String definition) {
        this.bpmnDefinition = definition;
    }

    public <T> TaskRoutedEvent<T> route(int taskSeq, TaskEvent<T> event) {
        BranchNode node = event.getNode();
        TaskState state = event.getState();
        int nextTaskSeq = this.routeMap.get(taskSeq).getRoute(state, node);
        RouteEvent routeEvent = RouteEvent.of(taskSeq, nextTaskSeq);
        return TaskRoutedEvent.of(event, routeEvent);
    }

    public void registerTask(int taskSeq, String taskUuid) {
        this.taskUuidMap.put(taskSeq, taskUuid);
        this.retryCountLimit.put(taskSeq, 0);
    }

    public void registerTask(int taskSeq, String taskUuid, boolean isAsync, int retryCountLimit) {
        this.taskUuidMap.put(taskSeq, taskUuid);
        if (isAsync) {
            this.asyncTasks.add(taskSeq);
        }
        this.retryCountLimit.put(taskSeq, retryCountLimit);
    }

    public void addActionFlow(int taskSeq, int nextTaskSeq) {
        this.routeMap.put(taskSeq, ActionRoute.of(nextTaskSeq));
    }

    public void addBranchFlow(int taskSeq, BranchNode node, int nextTaskSeq) {
        Route route = this.routeMap.getOrDefault(taskSeq, new BranchRoute());
        route.setRoute(node, nextTaskSeq);
        this.routeMap.put(taskSeq, route);
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void addEnd(int end) {
        this.ends.add(end);
        this.addActionFlow(end, TaskSeq.END.getSeqValue());
    }

    public String getUuid() {
        return this.uuid;
    }

    public Integer getStart() {
        return this.start;
    }

    public Set<Integer> getEnds() {
        return this.ends;
    }

    public Set<Integer> getAsyncTasks() {
        return this.asyncTasks;
    }

    public Map<Integer, Integer> getRetryCountLimit() {
        return this.retryCountLimit;
    }

    public Map<Integer, Integer> getNextTasks() {
        return this.nextTasks;
    }

    public Map<Integer, String> getTaskUuidMap() {
        return this.taskUuidMap;
    }

    public Map<Integer, Route> getRouteMap() {
        return this.routeMap;
    }

    public String getBpmnDefinition() {
        return this.bpmnDefinition;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setBpmnDefinition(String bpmnDefinition) {
        this.bpmnDefinition = bpmnDefinition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphContext)) {
            return false;
        }
        GraphContext other = (GraphContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        Integer this$start = this.getStart();
        Integer other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Set<Integer> this$ends = this.getEnds();
        Set<Integer> other$ends = other.getEnds();
        if (this$ends == null ? other$ends != null : !((Object)this$ends).equals(other$ends)) {
            return false;
        }
        Set<Integer> this$asyncTasks = this.getAsyncTasks();
        Set<Integer> other$asyncTasks = other.getAsyncTasks();
        if (this$asyncTasks == null ? other$asyncTasks != null : !((Object)this$asyncTasks).equals(other$asyncTasks)) {
            return false;
        }
        Map<Integer, Integer> this$retryCountLimit = this.getRetryCountLimit();
        Map<Integer, Integer> other$retryCountLimit = other.getRetryCountLimit();
        if (this$retryCountLimit == null ? other$retryCountLimit != null : !((Object)this$retryCountLimit).equals(other$retryCountLimit)) {
            return false;
        }
        Map<Integer, Integer> this$nextTasks = this.getNextTasks();
        Map<Integer, Integer> other$nextTasks = other.getNextTasks();
        if (this$nextTasks == null ? other$nextTasks != null : !((Object)this$nextTasks).equals(other$nextTasks)) {
            return false;
        }
        Map<Integer, String> this$taskUuidMap = this.getTaskUuidMap();
        Map<Integer, String> other$taskUuidMap = other.getTaskUuidMap();
        if (this$taskUuidMap == null ? other$taskUuidMap != null : !((Object)this$taskUuidMap).equals(other$taskUuidMap)) {
            return false;
        }
        Map<Integer, Route> this$routeMap = this.getRouteMap();
        Map<Integer, Route> other$routeMap = other.getRouteMap();
        if (this$routeMap == null ? other$routeMap != null : !((Object)this$routeMap).equals(other$routeMap)) {
            return false;
        }
        String this$bpmnDefinition = this.getBpmnDefinition();
        String other$bpmnDefinition = other.getBpmnDefinition();
        return !(this$bpmnDefinition == null ? other$bpmnDefinition != null : !this$bpmnDefinition.equals(other$bpmnDefinition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GraphContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        Integer $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Set<Integer> $ends = this.getEnds();
        result = result * 59 + ($ends == null ? 43 : ((Object)$ends).hashCode());
        Set<Integer> $asyncTasks = this.getAsyncTasks();
        result = result * 59 + ($asyncTasks == null ? 43 : ((Object)$asyncTasks).hashCode());
        Map<Integer, Integer> $retryCountLimit = this.getRetryCountLimit();
        result = result * 59 + ($retryCountLimit == null ? 43 : ((Object)$retryCountLimit).hashCode());
        Map<Integer, Integer> $nextTasks = this.getNextTasks();
        result = result * 59 + ($nextTasks == null ? 43 : ((Object)$nextTasks).hashCode());
        Map<Integer, String> $taskUuidMap = this.getTaskUuidMap();
        result = result * 59 + ($taskUuidMap == null ? 43 : ((Object)$taskUuidMap).hashCode());
        Map<Integer, Route> $routeMap = this.getRouteMap();
        result = result * 59 + ($routeMap == null ? 43 : ((Object)$routeMap).hashCode());
        String $bpmnDefinition = this.getBpmnDefinition();
        result = result * 59 + ($bpmnDefinition == null ? 43 : $bpmnDefinition.hashCode());
        return result;
    }

    public String toString() {
        return "GraphContext(uuid=" + this.getUuid() + ", start=" + this.getStart() + ", ends=" + this.getEnds() + ", asyncTasks=" + this.getAsyncTasks() + ", retryCountLimit=" + this.getRetryCountLimit() + ", nextTasks=" + this.getNextTasks() + ", taskUuidMap=" + this.getTaskUuidMap() + ", routeMap=" + this.getRouteMap() + ", bpmnDefinition=" + this.getBpmnDefinition() + ")";
    }
}

