/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.task.event;

import com.lvonce.wind.task.enums.FlowState;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;

public class FlowEvent<T> {
    final String id;
    final Timestamp time;
    final String source;
    final String subject;
    final String specversion;
    final String type;
    final String datacontenttype;
    final T data;
    final FlowState flowstate;

    public static <T> FlowEvent<T> of(FlowState flowState, T data) {
        return new FlowEvent<T>(UUID.randomUUID().toString(), Timestamp.from(Instant.now()), "system", "system", "1.0", "system", "json", data, flowState);
    }

    public static <T> FlowEvent<T> of(FlowState state) {
        return FlowEvent.of(state, null);
    }

    public static <T> FlowEvent<T> ofPending() {
        return FlowEvent.of(FlowState.PENDING, null);
    }

    public static <T> FlowEvent<T> ofCanceling() {
        return FlowEvent.of(FlowState.CANCELLING, null);
    }

    public static <T> FlowEvent<T> ofFail() {
        return FlowEvent.of(FlowState.FAIL, null);
    }

    public static <T> FlowEvent<T> ofAbort() {
        return FlowEvent.of(FlowState.ABORT, null);
    }

    public String getId() {
        return this.id;
    }

    public Timestamp getTime() {
        return this.time;
    }

    public String getSource() {
        return this.source;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSpecversion() {
        return this.specversion;
    }

    public String getType() {
        return this.type;
    }

    public String getDatacontenttype() {
        return this.datacontenttype;
    }

    public T getData() {
        return this.data;
    }

    public FlowState getFlowstate() {
        return this.flowstate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowEvent)) {
            return false;
        }
        FlowEvent other = (FlowEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Timestamp this$time = this.getTime();
        Timestamp other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$specversion = this.getSpecversion();
        String other$specversion = other.getSpecversion();
        if (this$specversion == null ? other$specversion != null : !this$specversion.equals(other$specversion)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$datacontenttype = this.getDatacontenttype();
        String other$datacontenttype = other.getDatacontenttype();
        if (this$datacontenttype == null ? other$datacontenttype != null : !this$datacontenttype.equals(other$datacontenttype)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        FlowState this$flowstate = this.getFlowstate();
        FlowState other$flowstate = other.getFlowstate();
        return !(this$flowstate == null ? other$flowstate != null : !((Object)((Object)this$flowstate)).equals((Object)other$flowstate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Timestamp $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $specversion = this.getSpecversion();
        result = result * 59 + ($specversion == null ? 43 : $specversion.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $datacontenttype = this.getDatacontenttype();
        result = result * 59 + ($datacontenttype == null ? 43 : $datacontenttype.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        FlowState $flowstate = this.getFlowstate();
        result = result * 59 + ($flowstate == null ? 43 : ((Object)((Object)$flowstate)).hashCode());
        return result;
    }

    public String toString() {
        return "FlowEvent(id=" + this.getId() + ", time=" + this.getTime() + ", source=" + this.getSource() + ", subject=" + this.getSubject() + ", specversion=" + this.getSpecversion() + ", type=" + this.getType() + ", datacontenttype=" + this.getDatacontenttype() + ", data=" + this.getData() + ", flowstate=" + (Object)((Object)this.getFlowstate()) + ")";
    }

    public FlowEvent(String id, Timestamp time, String source, String subject, String specversion, String type, String datacontenttype, T data, FlowState flowstate) {
        this.id = id;
        this.time = time;
        this.source = source;
        this.subject = subject;
        this.specversion = specversion;
        this.type = type;
        this.datacontenttype = datacontenttype;
        this.data = data;
        this.flowstate = flowstate;
    }
}

