/*
 * Decompiled with CFR 0.152.
 */
package com.lvonce.wind.task.event;

import com.lvonce.wind.task.enums.BranchNode;
import com.lvonce.wind.task.enums.TaskState;

public class TaskEvent<T> {
    final BranchNode node;
    final TaskState state;
    final T data;

    public static <T> TaskEvent<T> of(T data) {
        return TaskEvent.of(BranchNode.DEFAULT, TaskState.SUCCESS, data);
    }

    public static <T> TaskEvent<T> of(TaskState state) {
        return TaskEvent.of(BranchNode.DEFAULT, state, null);
    }

    public static <T> TaskEvent<T> of(TaskState state, T data) {
        return TaskEvent.of(BranchNode.DEFAULT, state, data);
    }

    public static <T> TaskEvent<T> of(BranchNode node, T data) {
        return TaskEvent.of(node, TaskState.SUCCESS, data);
    }

    public static <T> TaskEvent<T> of(BranchNode node, TaskState state, T data) {
        return new TaskEvent<T>(node, state, data);
    }

    public BranchNode getNode() {
        return this.node;
    }

    public TaskState getState() {
        return this.state;
    }

    public T getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskEvent)) {
            return false;
        }
        TaskEvent other = (TaskEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BranchNode this$node = this.getNode();
        BranchNode other$node = other.getNode();
        if (this$node == null ? other$node != null : !((Object)((Object)this$node)).equals((Object)other$node)) {
            return false;
        }
        TaskState this$state = this.getState();
        TaskState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BranchNode $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : ((Object)((Object)$node)).hashCode());
        TaskState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "TaskEvent(node=" + (Object)((Object)this.getNode()) + ", state=" + (Object)((Object)this.getState()) + ", data=" + this.getData() + ")";
    }

    public TaskEvent(BranchNode node, TaskState state, T data) {
        this.node = node;
        this.state = state;
        this.data = data;
    }
}

